/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 *  Copyright (C) 1994, 1995, 1996, 2001 Ralf Baechle
 *  Copyright (C) 1994, 1995, 1996 Paul M. Antoine.
 */

#define SAVE_AT                         \
		.set	push;           \
		.set	noat;           \
		sw	$1, PT_R1(sp);  \
		.set	pop

#define SAVE_TEMP                       \
		mfhi	v1;             \
		sw	$8, PT_R8(sp);  \
		sw	$9, PT_R9(sp);  \
		sw	v1, PT_HI(sp);  \
		mflo	v1;             \
		sw	$10,PT_R10(sp); \
		sw	$11, PT_R11(sp);\
		sw	v1,  PT_LO(sp); \
		sw	$12, PT_R12(sp);\
		sw	$13, PT_R13(sp);\
		sw	$14, PT_R14(sp);\
		sw	$15, PT_R15(sp);\
		sw	$24, PT_R24(sp)

#define SAVE_STATIC                     \
		sw	$16, PT_R16(sp);\
		sw	$17, PT_R17(sp);\
		sw	$18, PT_R18(sp);\
		sw	$19, PT_R19(sp);\
		sw	$20, PT_R20(sp);\
		sw	$21, PT_R21(sp);\
		sw	$22, PT_R22(sp);\
		sw	$23, PT_R23(sp);\
		sw	$30, PT_R30(sp)  

#define SAVE_SOME                                        \
		.set	push;                            \
		.set	reorder;                         \
		move	k0, sp;                          \
		subu	sp, sp, PT_SIZE;                 \
		sw	k0, PT_R29(sp);                  \
                sw	$3, PT_R3(sp);                   \
		mfc0	v1, CP0_STATUS;                  \
		sw	$2, PT_R2(sp);                   \
		sw	v1, PT_STATUS(sp);               \
		sw	$4, PT_R4(sp);                   \
		mfc0	v1, CP0_CAUSE;                   \
		sw	$5, PT_R5(sp);                   \
		sw	v1, PT_CAUSE(sp);                \
		sw	$6, PT_R6(sp);                   \
		mfc0	v1, CP0_EPC;                     \
		sw	$7, PT_R7(sp);                   \
		sw	v1, PT_EPC(sp);                  \
		sw	$25, PT_R25(sp);                 \
		sw	$28, PT_R28(sp);                 \
		sw	$31, PT_R31(sp);                 \
		.set	pop

#define	SAVE_FLOAT					\
		sdc1	$0, PT_FR0(sp);			\
		sdc1	$2, PT_FR2(sp);			\
		sdc1	$4, PT_FR4(sp);			\
		sdc1	$6, PT_FR6(sp);			\
		sdc1	$8, PT_FR8(sp);			\
		sdc1	$10, PT_FR10(sp);			\
		sdc1	$12, PT_FR12(sp);			\
		sdc1	$14, PT_FR14(sp);			\
		sdc1	$16, PT_FR16(sp);			\
		sdc1	$18, PT_FR18(sp);			\
		sdc1	$20, PT_FR20(sp);			\
		sdc1	$22, PT_FR22(sp);			\
		sdc1	$24, PT_FR24(sp);			\
		sdc1	$26, PT_FR26(sp);			\
		sdc1	$28, PT_FR28(sp);			\
		sdc1	$30, PT_FR30(sp);			\
		cfc1	$12, $25;			\
		sw	$12, PT_FCR25(sp);

#define SAVE_ALL                                         \
		SAVE_SOME;                               \
		SAVE_AT;                                 \
		SAVE_TEMP;                               \
		SAVE_STATIC;				\
		SAVE_FLOAT;

#define RESTORE_AT                                       \
		.set	push;                            \
		.set	noat;                            \
		lw	$1,  PT_R1(sp);                  \
		.set	pop;

#define RESTORE_TEMP                                     \
		lw	$24, PT_LO(sp);                  \
		lw	$8, PT_R8(sp);                   \
		lw	$9, PT_R9(sp);                   \
		mtlo	$24;                             \
		lw	$24, PT_HI(sp);                  \
		lw	$10,PT_R10(sp);                  \
		lw	$11, PT_R11(sp);                 \
		mthi	$24;                             \
		lw	$12, PT_R12(sp);                 \
		lw	$13, PT_R13(sp);                 \
		lw	$14, PT_R14(sp);                 \
		lw	$15, PT_R15(sp);                 \
		lw	$24, PT_R24(sp)

#define RESTORE_STATIC                                   \
		lw	$16, PT_R16(sp);                 \
		lw	$17, PT_R17(sp);                 \
		lw	$18, PT_R18(sp);                 \
		lw	$19, PT_R19(sp);                 \
		lw	$20, PT_R20(sp);                 \
		lw	$21, PT_R21(sp);                 \
		lw	$22, PT_R22(sp);                 \
		lw	$23, PT_R23(sp);                 \
		lw	$30, PT_R30(sp)

#define RESTORE_SOME                                     \
		.set	push;                            \
		.set	reorder;                         \
		mfc0	t0, CP0_STATUS;                  \
		.set	pop;                             \
		ori	t0, 0x1f;                        \
		xori	t0, 0x1f;                        \
		mtc0	t0, CP0_STATUS;                  \
		li	v1, 0xff00;                      \
		and	t0, v1;				 \
		lw	v0, PT_STATUS(sp);               \
		nor	v1, $0, v1;			 \
		and	v0, v1;				 \
		or	v0, t0;				 \
		mtc0	v0, CP0_STATUS;                  \
		lw	v1, PT_EPC(sp);                  \
		mtc0	v1, CP0_EPC;                     \
		lw	$31, PT_R31(sp);                 \
		lw	$28, PT_R28(sp);                 \
		lw	$25, PT_R25(sp);                 \
		lw	$7,  PT_R7(sp);                  \
		lw	$6,  PT_R6(sp);                  \
		lw	$5,  PT_R5(sp);                  \
		lw	$4,  PT_R4(sp);                  \
		lw	$3,  PT_R3(sp);                  \
		lw	$2,  PT_R2(sp)

#define	RESTORE_FLOAT					\
		ldc1	$0, PT_FR0(sp);			\
		ldc1	$2, PT_FR2(sp);			\
		ldc1	$4, PT_FR4(sp);			\
		ldc1	$6, PT_FR6(sp);			\
		ldc1	$8, PT_FR8(sp);			\
		ldc1	$10, PT_FR10(sp);			\
		ldc1	$12, PT_FR12(sp);			\
		ldc1	$14, PT_FR14(sp);			\
		ldc1	$16, PT_FR16(sp);			\
		ldc1	$18, PT_FR18(sp);			\
		ldc1	$20, PT_FR20(sp);			\
		ldc1	$22, PT_FR22(sp);			\
		ldc1	$24, PT_FR24(sp);			\
		ldc1	$26, PT_FR26(sp);			\
		ldc1	$28, PT_FR28(sp);			\
		ldc1	$30, PT_FR30(sp);			\
		lw	$12, PT_FCR25(sp);			\
		ctc1	$25, $12;

#define RESTORE_SP_AND_RET                               \
		lw	sp,  PT_R29(sp);                 \
		.set	mips3;				 \
		eret;					 \
		.set	mips0

#define RESTORE_SP                                       \
		lw	sp,  PT_R29(sp);                 \

#define RESTORE_ALL                                      \
		RESTORE_SOME;                            \
		RESTORE_AT;                              \
		RESTORE_FLOAT				\
		RESTORE_TEMP;                            \
		RESTORE_STATIC;                          \
		RESTORE_SP		

#define RESTORE_ALL_AND_RET                              \
		RESTORE_SOME;                            \
		RESTORE_AT;                              \
		RESTORE_FLOAT				\
		RESTORE_TEMP;                            \
		RESTORE_STATIC;                          \
		RESTORE_SP_AND_RET


/*
 * Move to kernel mode and disable interrupts.
 * Set cp0 enable bit as sign that we're running on the kernel stack
 */
#define CLI                                             \
		mfc0	t0,CP0_STATUS;                  \
		li	t1,ST0_CU0|0x1f;                \
		or	t0,t1;                          \
		xori	t0,0x1f;                        \
		mtc0	t0,CP0_STATUS

/*
 * Move to kernel mode and enable interrupts.
 * Set cp0 enable bit as sign that we're running on the kernel stack
 */
#define STI                                             \
		mfc0	t0,CP0_STATUS;                  \
		li	t1,ST0_CU0|0x1f;                \
		or	t0,t1;                          \
		xori	t0,0x1e;                        \
		mtc0	t0,CP0_STATUS

/*
 * Just move to kernel mode and leave interrupts as they are.
 * Set cp0 enable bit as sign that we're running on the kernel stack
 */
#define KMODE                                           \
		mfc0	t0,CP0_STATUS;                  \
		li	t1,ST0_CU0|0x1e;                \
		or	t0,t1;                          \
		xori	t0,0x1e;                        \
		mtc0	t0,CP0_STATUS

