#ifndef	__SEMB1200A_UX_SIGNAL_H__

#include	<semb1200a/ux1200e.h>
#include	<semb1200a/io.h>
#include	<semb1200a/ptrace.h>
#include	<semb1200a/mipsregs.h>

#define	UX_SIGNAL_VECTOR	(0x80000060UL)

#define	UX_SIG200		(0x30)		// (0x80000060)
#define	UX_SIG280		(0x31)		// (0x80000064)
#define	UX_SIG300		(0x32)		// (0x80000068)
#define	UX_SIG380		(0x33)		// (0x8000006C)
#define	UX_SIGIRQ5		(0x34)		// (0x80000070)
#define	UX_SIGIRQ2		(0x35)		// (0x80000074)
#define	UX_SIGIRQ1		(0x36)		// (0x80000078)
#define	UX_SIGIRQ0		(0x37)		// (0x8000007C)

#define	GET_CP0_COUNT		read_32bit_cp0_register(CP0_COUNT)

#define	SET_CP0_COUNT(X)	write_32bit_cp0_register(CP0_COUNT,(X))
#define	SET_CP0_COMPARE(X)	write_32bit_cp0_register(CP0_COMPARE,(X))

inline	static
void		ux_signal(
	int		sig,
	void		(*fnc)()
)
{
	unsigned long	adrs;

	sig &= 7;
	sig <<= 2;
	adrs = UX_SIGNAL_VECTOR + sig;
	*(unsigned long *)adrs = fnc;
}
inline	static
void		SET_CP0_STATUS(
	unsigned long	stat
)
{
	unsigned long	tmp;

	tmp = read_32bit_cp0_register( CP0_STATUS );
	tmp |= ST0_CU1 | ST0_IE | stat;
	write_32bit_cp0_register( CP0_STATUS, tmp );
}
inline	static
void		RESET_CP0_STATUS(
	unsigned long	stat
)
{
	unsigned long	tmp;

	tmp = read_32bit_cp0_register( CP0_STATUS );
	tmp |= ST0_CU1 | ST0_IE;
	tmp &= ~stat;
	write_32bit_cp0_register( CP0_STATUS, tmp );
}

#define	__SEMB1200A_UX_SIGNAL_H__
#endif
