#ifndef	__SEMB1200A_H__

#include	<semb1200a/ux1200e.h>
#include	<semb1200a/io.h>

#define	USE_LIBSEMB

#ifdef	__cplusplus
extern	"C"	{
#endif
/*	--------------------------------------------------------	*/
/*		萔ݒilj					*/
/*	--------------------------------------------------------	*/
//	--------------------------------
//		FPGA_PWM
//	--------------------------------
#define	PWM_PRESCALE		(8)			// 32(33MHz->1usec.), 4(33MHz->125nsec.) [note. min=4]
#define	PWM_UNIT_COUNT		(32 / PWM_PRESCALE)	// 1usec  main counter l

#define	PWM_CYCLE		(6000	* PWM_UNIT_COUNT)
#define	PWM_MIN			(646	* PWM_UNIT_COUNT)
#define	PWM_MAX			(2132	* PWM_UNIT_COUNT)
#define	PWM_MID			((PWM_MAX+PWM_MIN)/2)
#define	PWM_STEP		((PWM_MAX-PWM_MIN)/512)

#define	PWM_50usec		( 50 * PWM_UNIT_COUNT)	//  50usec(0.05msec)
#define	PWM_100usec		(100 * PWM_UNIT_COUNT)	// 100usec(0.10msec)
#define	PWM_200usec		(200 * PWM_UNIT_COUNT)	// 200usec(0.20msec)
#define	PWM_300usec		(300 * PWM_UNIT_COUNT)	// 300usec(0.30msec)
#define	PWM_350usec		(350 * PWM_UNIT_COUNT)	// 350usec(0.35msec)
#define	PWM_400usec		(400 * PWM_UNIT_COUNT)	// 400usec(0.40msec)

#define	PWM_OFFSET_CH0		(0)			// i[U[ύXj
#define	PWM_OFFSET_CH1		(0)			// i[U[ύXj
#define	PWM_OFFSET_CH2		(0)			// i[U[ύXj
#define	PWM_OFFSET_CH3		(0)			// i[U[ύXj
/*	--------------------------------------------------------	*/
/*		萔ݒ						*/
/*	--------------------------------------------------------	*/
//		SEMB1200A S
#define	CS5_BASE_ADDRESS		(0xBE000000UL)
//	--------------------------------
//		UART
//	--------------------------------
#define	UX_UART_DLM_50			(0x5A)
#define	UX_UART_DLL_50			(0x00)
#define	UX_UART_DLM_75			(0x3C)
#define	UX_UART_DLL_75			(0x00)
#define	UX_UART_DLM_110			(0x28)
#define	UX_UART_DLL_110			(0xE9)
#define	UX_UART_DLM_150			(0x1E)
#define	UX_UART_DLL_150			(0x00)
#define	UX_UART_DLM_300			(0x0F)
#define	UX_UART_DLL_300			(0x00)
#define	UX_UART_DLM_600			(0x07)
#define	UX_UART_DLL_600			(0x80)
#define	UX_UART_DLM_1200		(0x03)
#define	UX_UART_DLL_1200		(0xC0)
#define	UX_UART_DLM_2400		(0x01)
#define	UX_UART_DLL_2400		(0xE0)
#define	UX_UART_DLM_4800		(0x00)
#define	UX_UART_DLL_4800		(0xF0)
#define	UX_UART_DLM_9600		(0x00)
#define	UX_UART_DLL_9600		(0x78)
#define	UX_UART_DLM_19200		(0x00)
#define	UX_UART_DLL_19200		(0x3C)
#define	UX_UART_DLM_38400		(0x00)
#define	UX_UART_DLL_38400		(0x1E)
#define	UX_UART_DLM_56000		(0x00)
#define	UX_UART_DLL_56000		(0x15)
#define	UX_UART_DLM_115200		(0x00)
#define	UX_UART_DLL_115200		(0x0A)
#define	UX_UART_DLM_128000		(0x00)
#define	UX_UART_DLL_128000		(0x09)

#define	UX_UART_LCR_PARITY_FIX		(1<<5)
#define	UX_UART_LCR_PARITY_EVEN		((1<<4) | (1<<3))
#define	UX_UART_LCR_PARITY_ODD		(         (1<<3))
#define	UX_UART_LCR_PARITY_NON		(0)
#define	UX_UART_LCR_PARITY_USE		(1<<3)
#define	UX_UART_LCR_STOP_1		(0)
#define	UX_UART_LCR_STOP_1_5		(1<<2)
#define	UX_UART_LCR_LEN_5		(0)
#define	UX_UART_LCR_LEN_6		(1)
#define	UX_UART_LCR_LEN_7		(2)
#define	UX_UART_LCR_LEN_8		(3)
//	--------------------------------
//		CSI
//	--------------------------------
//		CSI PORT BIT
#define	CSI_DO				(1<< 8)		// GPIO40
#define	CSI_DI				(1<< 9)		// GPIO41
#define	CSI_CLK				(1<<10)		// GPIO42
#define	CSI_CS0				(1<<13)		// GPIO61
#define	CSI_CS1				(1<<12)		// GPIO60
//		CSI MODEREG
#define	CSI_MODEREG_CSIE		(1<< 7)
#define	CSI_MODEREG_TRMD		(1<< 6)
#define	CSI_MODEREG_CCL			(1<< 5)
#define	CSI_MODEREG_DIR			(1<< 4)
#define	CSI_MODEREG_AUTO		(1<< 2)
#define	CSI_MODEREG_CSOT		(1<< 0)
//		CSI CLKSELREG
#define	CSI_CLKSELREG_CKP		(1<< 4)
#define	CSI_CLKSELREG_DAP		(1<< 3)
#define	CSI_CLKSELREG_CKS_CLKDIV4	(1)		// 0b001
#define	CSI_CLKSELREG_CKS_CLKDIV8	(2)		// 0b010
#define	CSI_CLKSELREG_CKS_CLKDIV16	(3)		// 0b011
#define	CSI_CLKSELREG_CKS_CLKDIV32	(4)		// 0b100
#define	CSI_CLKSELREG_CKS_CLKDIV64	(5)		// 0b101
#define	CSI_CLKSELREG_CKS_CLKDIV128	(6)		// 0b110
#define	CSI_CLKSELREG_CKS_DEFAULT	(CSI_CKS_CLKDIV128)
//		CSI CNTREG
#define	CSI_CNTREG_CSIRST		(1<<15)
#define	CSI_CNTREG_T_TRGEN		(1<<12)
#define	CSI_CNTREG_T_FIFOF		(1<<11)
#define	CSI_CNTREG_T_FIFOE		(1<<10)
#define	CSI_CNTREG_SIRB_V		(1<< 6)
#define	CSI_CNTREG_R_FULLS		(1<< 5)
#define	CSI_CNTREG_R_TRGEN		(1<< 4)
#define	CSI_CNTREG_R_FIFOF		(1<< 3)
#define	CSI_CNTREG_R_FIFOE		(1<< 2)
//		CSI INTREG
#define	CSI_INTREG_CSIEND		(1<<15)
#define	CSI_INTREG_T_EMP		(1<<8)
#define	CSI_INTREG_R_OVER		(1<<0)
//	--------------------------------
//		FPGA_PWM
//	--------------------------------
#define	SEMB1200_PWM0			((CS5_BASE_ADDRESS) + 0x00000000UL)
#define	SEMB1200_PWM1			((CS5_BASE_ADDRESS) + 0x00000010UL)
#define	SEMB1200_PWM2			((CS5_BASE_ADDRESS) + 0x00000020UL)
#define	SEMB1200_PWM3			((CS5_BASE_ADDRESS) + 0x00000030UL)
//		FPGA_PWM COMMAND
#define	SEMB1200_MAIN_COUNT		(0x0000)
#define	SEMB1200_MAIN_COUNT_MAX_BUFFER	(0x0001)
#define	SEMB1200_MAIN_COUNT_MAX_DIRECT	(0x0002)
#define	SEMB1200_PRESCALE_MAX_COUNT	(0x0003)
#define	SEMB1200_COUNTER_MODE		(0x0007)
#define	SEMB1200_IO_SELECT		(0x0008)
#define	SEMB1200_OUTPUT_LEVEL		(0x000A)
#define	SEMB1200_OUT_TYPE		(0x000B)
#define	SEMB1200_PWM_GPIO_SELECT	(0x000C)
#define	SEMB1200_GPIO_DATA		(0x000D)

#define	SEMB1200_PWM0_UP_BUFFER		(0x0020)
#define	SEMB1200_PWM0_DOWN_BUFFER	(0x0021)
#define	SEMB1200_PWM1_UP_BUFFER		(0x0022)
#define	SEMB1200_PWM1_DOWN_BUFFER	(0x0023)
#define	SEMB1200_PWM2_UP_BUFFER		(0x0024)
#define	SEMB1200_PWM2_DOWN_BUFFER	(0x0025)
#define	SEMB1200_PWM3_UP_BUFFER		(0x0026)
#define	SEMB1200_PWM3_DOWN_BUFFER	(0x0027)
#define	SEMB1200_PWM4_UP_BUFFER		(0x0028)
#define	SEMB1200_PWM4_DOWN_BUFFER	(0x0029)
#define	SEMB1200_PWM5_UP_BUFFER		(0x002A)
#define	SEMB1200_PWM5_DOWN_BUFFER	(0x002B)
#define	SEMB1200_PWM6_UP_BUFFER		(0x002C)
#define	SEMB1200_PWM6_DOWN_BUFFER	(0x002D)
#define	SEMB1200_PWM7_UP_BUFFER		(0x002E)
#define	SEMB1200_PWM7_DOWN_BUFFER	(0x002F)

#define	SEMB1200_PWM0_UP_DIRECT		(0x0040)
#define	SEMB1200_PWM0_DOWN_DIRECT	(0x0041)
#define	SEMB1200_PWM1_UP_DIRECT		(0x0042)
#define	SEMB1200_PWM1_DOWN_DIRECT	(0x0043)
#define	SEMB1200_PWM2_UP_DIRECT		(0x0044)
#define	SEMB1200_PWM2_DOWN_DIRECT	(0x0045)
#define	SEMB1200_PWM3_UP_DIRECT		(0x0046)
#define	SEMB1200_PWM3_DOWN_DIRECT	(0x0047)
#define	SEMB1200_PWM4_UP_DIRECT		(0x0048)
#define	SEMB1200_PWM4_DOWN_DIRECT	(0x0049)
#define	SEMB1200_PWM5_UP_DIRECT		(0x004A)
#define	SEMB1200_PWM5_DOWN_DIRECT	(0x004B)
#define	SEMB1200_PWM6_UP_DIRECT		(0x004C)
#define	SEMB1200_PWM6_DOWN_DIRECT	(0x004D)
#define	SEMB1200_PWM7_UP_DIRECT		(0x004E)
#define	SEMB1200_PWM7_DOWN_DIRECT	(0x004F)

#define	SEMB1200_CAPTURE0_UP		(0x0040)
#define	SEMB1200_CAPTURE0_DOWN		(0x0041)
#define	SEMB1200_CAPTURE1_UP		(0x0042)
#define	SEMB1200_CAPTURE1_DOWN		(0x0043)
#define	SEMB1200_CAPTURE2_UP		(0x0044)
#define	SEMB1200_CAPTURE2_DOWN		(0x0045)
#define	SEMB1200_CAPTURE3_UP		(0x0046)
#define	SEMB1200_CAPTURE3_DOWN		(0x0047)
#define	SEMB1200_CAPTURE4_UP		(0x0048)
#define	SEMB1200_CAPTURE4_DOWN		(0x0049)
#define	SEMB1200_CAPTURE5_UP		(0x004A)
#define	SEMB1200_CAPTURE5_DOWN		(0x004B)
#define	SEMB1200_CAPTURE6_UP		(0x004C)
#define	SEMB1200_CAPTURE6_DOWN		(0x004D)
#define	SEMB1200_CAPTURE7_UP		(0x004E)
#define	SEMB1200_CAPTURE7_DOWN		(0x004F)

#define	SEMB1200_PWM_INT_MASK0		(0x00A0)
#define	SEMB1200_PWM_INT_MASK1		(0x00A1)
#define	SEMB1200_PWM_INT_MASK2		(0x00A2)
#define	SEMB1200_PWM_INT_STAT0		(0x00A4)
#define	SEMB1200_PWM_INT_STAT1		(0x00A5)
#define	SEMB1200_PWM_INT_STAT2		(0x00A6)
#define	SEMB1200_PWM_INT_PEND0		(0x00A8)
#define	SEMB1200_PWM_INT_PEND1		(0x00A9)
#define	SEMB1200_PWM_INT_PEND2		(0x00AA)
//	--------------------------------
//		FPGA_UART
//	--------------------------------
#define	UART3_0				((CS5_BASE_ADDRESS) + 0x00010000UL)
#define	UART3_1				((CS5_BASE_ADDRESS) + 0x00010010UL)
#define	UART3_2				((CS5_BASE_ADDRESS) + 0x00010020UL)
#define	UART3_3				((CS5_BASE_ADDRESS) + 0x00010030UL)
#define	UART3_4				((CS5_BASE_ADDRESS) + 0x00010040UL)
#define	UART3_5				((CS5_BASE_ADDRESS) + 0x00010050UL)
#define	UART3_6				((CS5_BASE_ADDRESS) + 0x00010060UL)
#define	UART3_7				((CS5_BASE_ADDRESS) + 0x00010070UL)
#define	UART3_SELECT			((CS5_BASE_ADDRESS) + 0x00020000UL)
#define	UART3_INTSTS			((CS5_BASE_ADDRESS) + 0x00020002UL)

#define	UART3_RBR			(0x00)
#define	UART3_TBR			(0x00)
#define	UART3_LCR			(0x02)
#define	UART3_LSR			(0x04)
#define	UART3_FSR			(0x06)
#define	UART3_IER			(0x08)
#define	UART3_FIFO_CLEAR		(0x0A)

#define	UART3_LCR_LEN_8			(0)
#define	UART3_LCR_LEN_7			(1<<6)
#define	UART3_LCR_PARITY_NON		(1<<5)
#define	UART3_LCR_PARITY_USE		(0)
#define	UART3_LCR_PARITY_ODD		(1<<4)
#define	UART3_LCR_PARITY_EVEN		(0)
#define	UART3_LCR_STOP_1		(0)
#define	UART3_LCR_STOP_1_5		(1<<3)
#define	UART3_LCR_2400			(0)
#define	UART3_LCR_4800			(1)
#define	UART3_LCR_9600			(2)
#define	UART3_LCR_19200			(3)
#define	UART3_LCR_38400			(4)
#define	UART3_LCR_57600			(5)
#define	UART3_LCR_115200		(6)
#define	UART3_LCR_230400		(7)
/*	--------------------------------------------------------	*/
/*		vg^Cv錾					*/
/*	--------------------------------------------------------	*/
//	--------------------------------
//		UART (uart.c)
//	--------------------------------
//		UART1
extern	void		uart1_init( unsigned char, unsigned char, unsigned char, unsigned char );
#ifdef	USE_LIBSEMB
extern	void		uart1_putchar( int );
extern	void		uart1_putc( int );
extern	int		uart1_data_ready( void );
extern	int		uart1_getc( void );
extern	int		uart1_getchar( int * );
#endif
extern	void		uart1_puts( const char * );
extern	char		*uart1_gets( char *, int, int );
extern	void		uart1_out1h( unsigned char );
extern	void		uart1_out2h( unsigned char );
extern	void		uart1_out4h( unsigned short );
extern	void		uart1_out8h( unsigned long );
//		UART2
extern	void		uart2_init( unsigned char, unsigned char, unsigned char, unsigned char );
#ifdef	USE_LIBSEMB
extern	void		uart2_putchar( int );
extern	void		uart2_putc( int );
extern	int		uart2_data_ready( void );
extern	int		uart2_getc( void );
extern	int		uart2_getchar( int * );
#endif
//	--------------------------------
//		CSI (csi.c)
//	--------------------------------
extern	void		csi_init( unsigned char, unsigned char );
#ifdef	USE_LIBSEMB
extern	unsigned short	csi_getc( void );
extern	void		csi_putc( unsigned short );
extern	unsigned short	csi_putcgetc( unsigned short );
#endif
//	--------------------------------
//		FPGA_PWM
//	--------------------------------
#ifdef	SAMPLE_OF_PWM
extern	unsigned short	pwm_up[], pwm_down[], cpt[];
extern	int		flag_end_of_capture;
#endif
extern	void		pwm_set( int, int, unsigned short, unsigned short );
extern	void		pwm_set_with_direct( int, int, unsigned short, unsigned short );
extern	unsigned short	pwm_get( int, int );
extern	void		pwm_init( int, unsigned short, unsigned short, unsigned short );
extern	void		init_pwm_unit( int );
extern	void		init_pwm_unit_all( void );
extern	void		set_pwm( int, unsigned short, unsigned short );
extern	void		set_pwm_with_direct( int, unsigned short, unsigned short );
extern	unsigned short	get_pwm( int );
extern	void		init_pwm_value( void );
extern	void		set_pwm_all( void );
extern	void		set_pwm_with_direct_all( void );
extern	void		get_capture_all( void );

#define	capture(X,Y)	pwm_get((X),(Y))
//	--------------------------------
//		FPGA_UART
//	--------------------------------
extern	void		uart3_init( int, unsigned short );
extern	void		uart3_init_default_all( void );
extern	void		uart3_fifoclr( int );
#ifdef	USE_LIBSEMB
extern	void		uart3_putchar( int, int );
extern	void		uart3_putc( int, int );
extern	int		uart3_data_ready( int );
extern	int		uart3_getc( int );
extern	int		uart3_getchar( int, int * );
#endif
/*	--------------------------------------------------------	*/
/*		CC֐						*/
/*	--------------------------------------------------------	*/
//	--------------------------------
//		UART
//	--------------------------------
#ifndef	USE_LIBSEMB
inline static
void		uart1_putchar(
	int		c
)
{
	while( ( io_in16( UART_1LSR ) & 0x20 ) == 0 ) ;
	io_out16( UART_1THR, c );
}
inline static
void		uart1_putc(
	int		c
)
{
	if( c == '\n' ) {
		uart1_putchar( '\r' );
	}
	uart1_putchar( c );
}
inline static
int		uart1_data_ready( void )
{
	int		s;

	s = io_in16( UART_1LSR );
	s &= 1;
	return s;
}
inline static
int		uart1_getchar(
	int		*c
)
{
	if( uart1_data_ready() == 0 ) {
		*c = 0;
		return 0;
	}
	*c = io_in16( UART_1RBR );
	return 1;
}
inline static
int		uart1_getc( void )
{
	while( uart1_data_ready() == 0 ) ;
	return (int)io_in16( UART_1RBR );
}
inline static
void		uart2_putchar(
	int		c
)
{
	while( ( io_in16( UART_2LSR ) & 0x20 ) == 0 ) ;
	io_out16( UART_2THR, c );
}
inline static
void		uart2_putc(
	int		c
)
{
	if( c == '\n' ) {
		uart2_putchar( '\r' );
	}
	uart2_putchar( c );
}
inline static
int		uart2_data_ready( void )
{
	int		s;

	s = io_in16( UART_2LSR );
	s &= 1;
	return s;
}
inline static
int		uart2_getchar(
	int		*c
)
{
	if( uart2_data_ready() == 0 ) {
		*c = 0;
		return 0;
	}
	*c = io_in16( UART_2RBR );
	return 1;
}
inline static
int		uart2_getc( void )
{
	while( uart2_data_ready() == 0 ) ;
	return (int)io_in16( UART_2RBR );
}
#endif
//	--------------------------------
//		CSI
//	--------------------------------
#ifndef	USE_LIBSEMB
inline static
unsigned short	csi_getc( void )
{
	while( ( io_in16( CSI_CNTREG ) & CSI_CNTREG_SIRB_V ) == 0 ) ;
	return (int)io_in16( CSI_SIRBEREG );
}
inline static
void		csi_putc(
	unsigned short	dat
)
{
	while( ( io_in8( CSI_MODEREG ) & CSI_MODEREG_CSOT ) != 0 ) ;
	io_out16( CSI_SOTBREG, dat );
}
inline static
unsigned short	csi_putcgetc(
	unsigned short	dat
)
{
	while( ( io_in8( CSI_MODEREG ) & CSI_MODEREG_CSOT ) != 0 ) ;
	io_out16( CSI_SOTBREG, dat );

	while( ( io_in16( CSI_CNTREG ) & CSI_CNTREG_SIRB_V ) == 0 ) ;
	return io_in16( CSI_SIRBREG );
}
#endif
//	--------------------------------
//		FPGA_PWM
//	--------------------------------
inline static
unsigned long	_pwm_adrs(
	int		unit_number
)
{
	unsigned long	adrs;

	switch( unit_number ) {
	    default:
	    case 0:	adrs = SEMB1200_PWM0;	break;
	    case 1:	adrs = SEMB1200_PWM1;	break;
	    case 2:	adrs = SEMB1200_PWM2;	break;
	    case 3:	adrs = SEMB1200_PWM3;	break;
	}
	return adrs;
}
inline static
void		pwm_unit_set(
	int		unit_number,
	unsigned short	cmd,
	unsigned short	dat
)
{
	unsigned long	adrs;

	adrs = _pwm_adrs( unit_number );
	io_out16( adrs,     cmd );
	io_out16( adrs + 2, dat );
}
inline static
unsigned short	pwm_unit_get(
	int		unit_number,
	unsigned short	cmd
)
{
	unsigned long	adrs;

	adrs = _pwm_adrs( unit_number );
	io_out16( adrs, cmd );
	return io_in16( adrs + 2 );
}
inline static
void		pwm_unit_and(
	int		unit_number,
	unsigned short	cmd,
	unsigned short	dat
)
{
	unsigned long	adrs;

	adrs = _pwm_adrs( unit_number );
	io_out16( adrs,     cmd );
	io_and16( adrs + 2, dat );
}
inline static
void		pwm_unit_not(
	int		unit_number,
	unsigned short	cmd,
	unsigned short	dat
)
{
	pwm_unit_and( unit_number, cmd, ~dat );
}
inline static
void		pwm_unit_or(
	int		unit_number,
	unsigned short	cmd,
	unsigned short	dat
)
{
	unsigned long	adrs;

	adrs = _pwm_adrs( unit_number );
	io_out16( adrs,     cmd );
	io_or16(  adrs + 2, dat );
}
inline static
void		pwm_count_disable(
	int		unit_number
)
{
	pwm_unit_not( unit_number, SEMB1200_COUNTER_MODE, 1 << 0 );
}
inline static
void		pwm_count_enable(
	int		unit_number
)
{
	pwm_unit_or( unit_number, SEMB1200_COUNTER_MODE, 1 << 0 );
}
inline static
void		pwm_count_disable_all( void )
{
	pwm_count_disable( 0 );
	pwm_count_disable( 1 );
	pwm_count_disable( 2 );
	pwm_count_disable( 3 );
}
inline static
void		pwm_count_enable_all( void )
{
	pwm_count_enable( 3 );
	pwm_count_enable( 2 );
	pwm_count_enable( 1 );
	pwm_count_enable( 0 );
}

#define	capture(X,Y)		pwm_get((X),(Y))

//	--------------------------------
//		FPGA_UART
//	--------------------------------
inline static
unsigned long	_uart3_adrs(
	int		unit_number
)
{
	unsigned long	adrs;

	switch( unit_number ) {
	    default:
	    case 0:	adrs = UART3_0;		break;
	    case 1:	adrs = UART3_1;		break;
	    case 2:	adrs = UART3_2;		break;
	    case 3:	adrs = UART3_3;		break;
	    case 4:	adrs = UART3_4;		break;
	    case 5:	adrs = UART3_5;		break;
	    case 6:	adrs = UART3_6;		break;
	    case 7:	adrs = UART3_7;		break;
	}
	return adrs;
}
inline static
void		uart3_unit_set(
	int		unit_number,
	unsigned short	cmd,
	unsigned short	dat
)
{
	unsigned long	adrs;

	adrs = _uart3_adrs( unit_number ) + cmd;
	io_out16( adrs, dat );
}
inline static
unsigned short	uart3_unit_get(
	int		unit_number,
	unsigned short	cmd
)
{
	unsigned long	adrs;

	adrs = _uart3_adrs( unit_number ) + cmd;
	return io_in16( adrs );
}
inline static
void		uart3_put_select(
	unsigned short	dat
)
{
	io_out16( UART3_SELECT, dat );
}
inline static
unsigned short	uart3_get_select( void )
{
	return io_in16( UART3_SELECT );
}
inline static
unsigned short	uart3_set_select(
	int		unit_number
)
{
	unsigned short	tmp;

	tmp = uart3_get_select();
	tmp |= ( 1 << unit_number );
	uart3_put_select( tmp );
}
inline static
unsigned short	uart3_intsts( void )
{
	io_in16( UART3_INTSTS );
}
#ifndef	USE_LIBSEMB
inline static
void		uart3_putchar(
	int		un,
	int		c
)
{
	uart3_unit_put( un, UART3_TBR, c );
}
inline static
void		uart3_putc(
	int		un,
	int		c
)
{
	if( c == '\n' ) {
		uart3_putchar( un, '\r' );
	}
	uart3_putchar( un, c );
}
inline static
int		uart3_data_ready(
	int		un
)
{
	int		s;

	s = uart3_unit_get( un, UART3_FSR );
	s &= 1;
	return s;
}
inline static
int		uart3_getchar(
	int		un,
	int		*c
)
{
	if( uart3_data_ready( un ) == 1 ) {
		*c = 0;
		return 0;
	}
	*c = uart3_unit_get( un, UART3_RBR );
	return 1;
}
inline static
int		uart3_getc(
	int		un
)
{
	while( uart3_data_ready( un ) == 1 ) ;
	return uart3_unit_get( un, UART3_RBR );
}
#endif
/*	********************************************************	*/
#ifdef	__cplusplus
}
#endif
#define	__SEMB1200A_H__
#endif
