#ifndef _MIPS_OFFSET_H
#define _MIPS_OFFSET_H

/* MIPS pt_regs offsets. */
#define PT_R0     (4 * 0)
#define PT_R1     (4 * 1)
#define PT_R2     (4 * 2)
#define PT_R3     (4 * 3)
#define PT_R4     (4 * 4)
#define PT_R5     (4 * 5)
#define PT_R6     (4 * 6)
#define PT_R7     (4 * 7)
#define PT_R8     (4 * 8)
#define PT_R9     (4 * 9)
#define PT_R10    (4 * 10)
#define PT_R11    (4 * 11)
#define PT_R12    (4 * 12)
#define PT_R13    (4 * 13)
#define PT_R14    (4 * 14)
#define PT_R15    (4 * 15)
#define PT_R16    (4 * 16)
#define PT_R17    (4 * 17)
#define PT_R18    (4 * 18)
#define PT_R19    (4 * 19)
#define PT_R20    (4 * 20)
#define PT_R21    (4 * 21)
#define PT_R22    (4 * 22)
#define PT_R23    (4 * 23)
#define PT_R24    (4 * 24)
#define PT_R25    (4 * 25)
#define PT_R26    (4 * 26)
#define PT_R27    (4 * 27)
#define PT_R28    (4 * 28)
#define PT_R29    (4 * 29)
#define PT_R30    (4 * 30)
#define PT_R31    (4 * 31)
#define PT_LO     (4 * 32)
#define PT_HI     (4 * 33)
#define PT_EPC    (4 * 34)
#define PT_BVADDR (4 * 35)
#define PT_STATUS (4 * 36)
#define PT_CAUSE  (4 * 37)
#define PT_FR0    (4 * 38)
#define PT_FR1    (4 * 39)
#define PT_FR2    (4 * 40)
#define PT_FR3    (4 * 41)
#define PT_FR4    (4 * 42)
#define PT_FR5    (4 * 43)
#define PT_FR6    (4 * 44)
#define PT_FR7    (4 * 45)
#define PT_FR8    (4 * 46)
#define PT_FR9    (4 * 47)
#define PT_FR10   (4 * 48)
#define PT_FR11   (4 * 49)
#define PT_FR12   (4 * 50)
#define PT_FR13   (4 * 51)
#define PT_FR14   (4 * 52)
#define PT_FR15   (4 * 53)
#define PT_FR16   (4 * 54)
#define PT_FR17   (4 * 55)
#define PT_FR18   (4 * 56)
#define PT_FR19   (4 * 57)
#define PT_FR20   (4 * 58)
#define PT_FR21   (4 * 59)
#define PT_FR22   (4 * 60)
#define PT_FR23   (4 * 61)
#define PT_FR24   (4 * 62)
#define PT_FR25   (4 * 63)
#define PT_FR26   (4 * 64)
#define PT_FR27   (4 * 65)
#define PT_FR28   (4 * 66)
#define PT_FR29   (4 * 67)
#define PT_FR30   (4 * 68)
#define PT_FR31   (4 * 69)
#define PT_FCR25  (4 * 70)
#define PT_PAD    (4 * 71)
#define PT_SIZE   (4 * 72)

/* MIPS task_struct offsets. */
#define TASK_STATE         0
#define TASK_FLAGS         4
#define TASK_SIGPENDING    8
#define TASK_NEED_RESCHED  20
#define TASK_PTRACE        24
#define TASK_COUNTER       32
#define TASK_NICE          36
#define TASK_MM            44
#define TASK_PID           124
#define TASK_STRUCT_SIZE   1048
#define PT_TRACESYS        0x2

/* MIPS specific thread_struct offsets. */
#define THREAD_REG16   616
#define THREAD_REG17   620
#define THREAD_REG18   624
#define THREAD_REG19   628
#define THREAD_REG20   632
#define THREAD_REG21   636
#define THREAD_REG22   640
#define THREAD_REG23   644
#define THREAD_REG29   648
#define THREAD_REG30   652
#define THREAD_REG31   656
#define THREAD_STATUS  660
#define THREAD_FPU     664
#define THREAD_BVADDR  928
#define THREAD_BUADDR  932
#define THREAD_ECODE   936
#define THREAD_TRAPNO  940
#define THREAD_MFLAGS  944
#define THREAD_CURDS   948
#define THREAD_TRAMP   952
#define THREAD_OLDCTX  956

/* Linux mm_struct offsets. */
#define MM_USERS      16
#define MM_PGD        12
#define MM_CONTEXT    120

#define _PAGE_SIZE     0x1000
#define _PGD_ORDER     0x0
#define _PGDIR_SHIFT   0x16

/* Linux sigcontext offsets. */
#define SC_REGS       16
#define SC_FPREGS     272
#define SC_MDHI       552
#define SC_MDLO       560
#define SC_PC         8
#define SC_STATUS     4
#define SC_OWNEDFP    528
#define SC_FPC_CSR    532
#define SC_FPC_EIR    536
#define SC_CAUSE      568
#define SC_BADVADDR   572

/* Linux signal numbers. */
#define _SIGHUP     0x1
#define _SIGINT     0x2
#define _SIGQUIT    0x3
#define _SIGILL     0x4
#define _SIGTRAP    0x5
#define _SIGIOT     0x6
#define _SIGABRT    0x6
#define _SIGEMT     0x7
#define _SIGFPE     0x8
#define _SIGKILL    0x9
#define _SIGBUS     0xa
#define _SIGSEGV    0xb
#define _SIGSYS     0xc
#define _SIGPIPE    0xd
#define _SIGALRM    0xe
#define _SIGTERM    0xf
#define _SIGUSR1    0x10
#define _SIGUSR2    0x11
#define _SIGCHLD    0x12
#define _SIGPWR     0x13
#define _SIGWINCH   0x14
#define _SIGURG     0x15
#define _SIGIO      0x16
#define _SIGSTOP    0x17
#define _SIGTSTP    0x18
#define _SIGCONT    0x19
#define _SIGTTIN    0x1a
#define _SIGTTOU    0x1b
#define _SIGVTALRM  0x1c
#define _SIGPROF    0x1d
#define _SIGXCPU    0x1e
#define _SIGXFSZ    0x1f
#endif /* !(_MIPS_OFFSET_H) */
