#ifndef	__IO_H__
# define	__IO_H__

static void __delay(unsigned long loops)
{
	__asm__ __volatile__ (
		".set\tnoreorder\n"
		"1:\tbnez\t%0,1b\n\t"
		"subu\t%0,1\n\t"
		".set\treorder"
		:"=r" (loops)
		:"0" (loops));
}
static inline void	io_sync( void )
{
	int		tmp, tmp2;

	asm( "sync" );
	for( tmp = 0; tmp < 100; tmp++ ) {
		tmp2 = 0x200;
	}
}
static inline unsigned char	io_in8(
	unsigned long	adr
)
{
	unsigned char	val;

	val = *(volatile unsigned char *)adr;
	io_sync();
	return val;
}
static inline unsigned short	io_in16(
	unsigned long	adr
)
{
	unsigned short	val;

	val = *(volatile unsigned short *)adr;
	io_sync();
	return val;
}
static inline unsigned long	io_in32(
	unsigned long	adr
)
{
	unsigned long	val;

	val = *(volatile unsigned long *)adr;
	io_sync();
	return val;
}
static inline void	io_out8(
	unsigned long	adr,
	unsigned char	val
)
{
	*(volatile unsigned char *)adr = val;
	io_sync();
}
static inline void	io_out16(
	unsigned long	adr,
	unsigned short	val
)
{
	*(volatile unsigned short *)adr = val;
	io_sync();
}
static inline void	io_out32(
	unsigned long	adr,
	unsigned long	val
)
{
	*(volatile unsigned long *)adr = val;
	io_sync();
}
static inline void	io_reset32(
	unsigned long adr,
	unsigned long val1,
	unsigned long delay,
	unsigned long val2
)
{
	io_out32( adr, val1 );
	__delay( delay );
	io_out32( adr, val2 );
}
static inline void	io_reset16(
	unsigned long	adr,
	unsigned short	val1,
	unsigned long	delay,
	unsigned short	val2
)
{
	io_out16( adr, val1 );
	__delay( delay );
	io_out16( adr, val2 );
}
static inline void	io_set16(
	unsigned long	adr,
	unsigned short	mask,
	unsigned short	val
)
{
	unsigned short	val0;

	val0 = *(volatile unsigned short *)adr;
	*(volatile unsigned short *)adr =( val & mask )|( val0 & ~mask );
	io_sync();
}
static inline void	io_and16(
	unsigned long	adr,
	unsigned short	val
)
{
	*(volatile unsigned short *)adr &= val;
	io_sync();
}
static inline void	io_or16(
	unsigned long	adr,
	unsigned short	val
)
{
	*(volatile unsigned short *)adr |= val;
	io_sync();
}
static inline void	io_or32(
	unsigned long	adr,
	unsigned long	val
)
{
	*(volatile unsigned long *)adr |= val;
	io_sync();
}
#endif
