/*
 * Created on Oct 12, 2003
 *
 */
package techniques.utils;

/**
 * @author vineet
 *
 */
public class Random {
	/**
	 * Returns true with probability 0.5.
	 */
	public static boolean coinFlip() {
		if (Math.random()>0.5) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * Returns uniformly a number between 0 and max-1 (inclusive)
	 */
	public static int random(int max) {
		return (int) Math.floor(Math.random() * max);
	}
	
	/**
	 * Samples from input based on given complete probability 
	 * distribution (prob. sum to 1).
	 * @param prob - array of probabilities (summing to 1)
	 * @return - value between 0 and prob.length (inclusive)
	 * based on uniform sampling of input prob
	 */
	public static int sampleCompleteProbDist(double [] prob) {
		
		/*
		double sumDist = 0;
		for (int i = 0; i < prob.length; i++) {
			sumDist += prob[i];
		}
		if (sumDist<0.999) {
			//throw new RuntimeException("Error in sampleCompleteProbDist (not summing to 1)");
			System.err.println("Error in sampleCompleteProbDist (not summing to 1)");
			return -1;
		}
		*/

		// multiple agains 0.9999 incase the sum is slightly off
		double uniDist = Math.random() * 0.9999;
		//double origDist = uniDist;
		//double sumDist = 0;
		for (int i = 0; i < prob.length; i++) {
			//sumDist += prob[i];
			uniDist -= prob[i];
			if (uniDist < 0) {
				return i;
			}
		}
		// given distribution could not have added to 1
		System.err.println("Error in sampleCompleteProbDist (not summing to 1)");
		return -1;
	}

	/**
	 * Samples from input based on given probability distribution. Is more flexible
	 * than sampleCompleteProbDist since the prob. dist. don't need to sum to 1,
	 * however, sampleCompleteProbDist includes an implicit error check. 
	 * @param prob - array of probabilities
	 * @return - value between 0 and prob.length (inclusive)
	 * based on uniform sampling of input prob
	 */
	public static int samplePartialProbDist(double [] prob) {
		double sumDist = 0;
		for (int i = 0; i < prob.length; i++) {
			sumDist += prob[i];
		}
		
		double uniDist = sumDist * Math.random();
		for (int i = 0; i < prob.length; i++) {
			//sumDist += prob[i];
			uniDist -= prob[i];
			if (uniDist < 0) {
				return i;
			}
		}
		
		return -1;
	}
			  
}
