package edu.mit.six825.bn.inputs;


import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import edu.mit.six825.bn.bayesnet.BayesNet;
import edu.mit.six825.bn.bayesnet.BayesNetNode;
import edu.mit.six825.bn.bayesnet.BayesNetNodeSet;
import edu.mit.six825.bn.functiontable.Domain;
import edu.mit.six825.bn.functiontable.Function;
import edu.mit.six825.bn.functiontable.FunctionVariable;
import edu.mit.six825.bn.functiontable.FunctionVariableSet;

import techniques.BN.Variable;
import edu.mit.six825.bn.functiontable.Assignment;
import edu.mit.six825.bn.functiontable.Compute;



/**
 * @author drayside
 */
public class Nets {

	public static edu.mit.six825.bn.bayesnet.BayesNet getInsurance() {
		return convertOldToNew(techniques.BN.Nets.getInsurance());
	}

	public static edu.mit.six825.bn.bayesnet.BayesNet getBurglary() {
		return convertOldToNew(techniques.BN.Nets.getBurglary());
	}

	public static edu.mit.six825.bn.bayesnet.BayesNet getCarpo() {
		return convertOldToNew(techniques.BN.Nets.getCarpo());
	}

	public static edu.mit.six825.bn.bayesnet.BayesNet convertOldToNew(final techniques.BN.BayesNet oldNet) {

		final List oldNodesTopological = oldNet.getNodesWithTopologicalOrdering();
		final BayesNetNode[] newNodes = new BayesNetNode[oldNodesTopological.size()];

		// get each variable, in topological order
		int ndx = 0;
		for (final Iterator topologicalIterator = oldNodesTopological.iterator(); topologicalIterator.hasNext(); ) {
			final Variable v = (Variable)topologicalIterator.next();

			// the node itself
			// first determine the domain
			final Object[] domainValues = v.getGivenValues();
			final Domain domain;
			if (domainValues[0] instanceof Boolean) {
				domain = Domain.BOOLEAN_DOMAIN;
			} else if (domainValues[0] instanceof String) {
				final Comparable[] vals = new Comparable[domainValues.length];
				System.arraycopy(domainValues, 0, vals, 0, vals.length);
				Arrays.sort(vals);
				domain = new Domain(vals);
			} else {
				throw new RuntimeException("unknown domain value: " + domainValues[0] + " " + domainValues[0].getClass().toString());
			}

			final FunctionVariable fv = new FunctionVariable(v.getName(), domain);

			// the parent nodes (+ self)
			final Variable[] oldParents = v.getParents();
			final BayesNetNodeSet newParents;
			final FunctionVariableSet newParentsPlusSelf;
			if (oldParents.length == 0) {
				newParents = BayesNetNodeSet.EMPTY_BAYES_NET_VARIABLE_SET;
				newParentsPlusSelf = new FunctionVariableSet(fv);
			} else {
				BayesNetNode[] newParentsArray = new BayesNetNode[oldParents.length];
				for (int i = 0; i < oldParents.length; i++) {
					final Variable oldParent = oldParents[i];
					// since we're going in topological order, we must have
					// constructed the parents already: look them up
					for (int j = 0; j < ndx; ++j) {
						if (newNodes[j].var.name.equals(oldParent.getName())) {
							// found it
							newParentsArray[i] = newNodes[j];
						}
					}
				}
				newParents = new BayesNetNodeSet(newParentsArray);
				final FunctionVariable[] tmp = new FunctionVariable[newParentsArray.length+1];
				for (int k = 0; k < newParentsArray.length; k++) {
					tmp[k] = newParentsArray[k].var;
				}
				tmp[tmp.length-1] = fv;
				Arrays.sort(tmp);
				newParentsPlusSelf = new FunctionVariableSet(tmp);
			}



			// now the function ...
			//final FunctionConstructor constructor =
			//	new AdapterFunctionConstructor(newParentsPlusSelf, v.getProbTable());
			//final Function function = new Function(constructor);
			Function function = AdapterFunctionConstructor.compute(newParentsPlusSelf, v.getProbTable());

                        // fix 0s and 1s in CPTs
                        FunctionVariableSet vars = function.variables;
                        double [] vals = new double[vars.cartesianProductSize()];
                        Iterator asgnIt = vars.assignmentIterator();
                        while (asgnIt.hasNext()) {
                            Assignment asgn = (Assignment) asgnIt.next();
                            double value = function.evaluate(asgn);
                            if (value == 0) {
                                value += 1e-100;
                            }
                            if (value == 1) {
                                value -= 1e-100;
                            }
                            vals[asgn.computePosition()] = value;
                        }

                      final Function fixedFunction = new Function(vars, vals);
                      newNodes[ndx++] = new BayesNetNode(fv, newParents, fixedFunction);
		}
		// clean out the old junk
		System.gc();
		System.gc();
		System.gc();

		// return the new net
		return new BayesNet(new BayesNetNodeSet(newNodes));

	}

}
