package edu.mit.six825.bn.inputs;

import java.util.HashMap;

import edu.mit.six825.bn.functiontable.Assignment;
import edu.mit.six825.bn.functiontable.BaseFunctionConstructor;
import edu.mit.six825.bn.functiontable.ComparableBoolean;
import edu.mit.six825.bn.functiontable.Function;
import edu.mit.six825.bn.functiontable.FunctionEntry;
import edu.mit.six825.bn.functiontable.FunctionVariable;
import edu.mit.six825.bn.functiontable.FunctionVariableSet;


import techniques.BN.ProbTable;
import techniques.BN.Variable;

/**
 * @author drayside
 */
public class AdapterFunctionConstructor extends BaseFunctionConstructor {
	private final ProbTable table;
	//private final techniques.BN.BayesNet oldBayesNet;
	
	public AdapterFunctionConstructor(final FunctionVariableSet set, final ProbTable table) {
		super(set);
		this.table = table;
	}

	public static Function compute(FunctionVariableSet set, ProbTable table) {
		return new Function(new AdapterFunctionConstructor(set, table));
	}
	
	public FunctionEntry next() {
		// need to convert new assignment to old assignment
		final Assignment assignment = (Assignment)assignmentIterator.next();
		final HashMap oldAssignment = new HashMap();
		for (int i = 0; i < assignment.variables.size(); i++) {
			final FunctionVariable fv = assignment.variables.getVariable(i);
			final Comparable val = assignment.getAssignedValue(fv);
			final Variable oldVar = lookupOldVariable(fv);
			oldAssignment.put(oldVar, lookupOldValue(oldVar, val));
		}
		//final HashMap oldAssignment = (HashMap) tableIterator.next();
		final double d = table.getProb(oldAssignment);
		return new FunctionEntry(assignment, d);
	}

	private Variable lookupOldVariable(final FunctionVariable v) {
		final Variable[] oldVars = table.getVariables();
		for (int i = 0; i < oldVars.length; i++) {
			if (v.name.equals(oldVars[i].getName())) return oldVars[i];
		}
		return null;
	}
	
	private Integer lookupOldValue(final Variable oldVar, final Comparable newValue) {
		// TODO: make lookupOldValue() more general
		final Object[] oldValues = oldVar.getGivenValues();
		for (int i = 0; i < oldValues.length; i++) {
			if (oldValues[i] instanceof Boolean) {
				final Boolean oldValue = (Boolean)oldValues[i];
				if (newValue instanceof ComparableBoolean) {
					final ComparableBoolean cb = (ComparableBoolean)newValue;
					if (cb.value == oldValue.booleanValue()) return new Integer(i);
				}
			} else if (oldValues[i] instanceof String) {
				if (newValue.equals(oldValues[i])) return new Integer(i);
			} else throw new RuntimeException();
		}
		return null;
	}
}
	