package edu.mit.six825.bn.functiontable;

/**
 * @author drayside
 */
public class Utility {

	/**
	 * 
	 * @param a1
	 * @param a2
	 * @return -1 if a1 is less than a2; 1 if a1 is greater than a2; 0 if they're equal
	 */
	public static int compareTwoArrays(final Comparable[] a1, final Comparable[] a2) {
		if (a1.length < a2.length) return -1;
		else if (a1.length > a2.length) return 1;
		else {
			for (int i = 0; i < a1.length; i++) {
				final int c = a1[i].compareTo(a2[i]);
				if (0 != c) return c;
			}
			return 0;
		}
	}

	/**
	 * 
	 * @param obj1 
	 * @param obj2 this should be a Comparable, but not statically enforced
	 * @return true if these two objects are equals
	 */
	public static boolean equals_basedOnCompareTo(final Comparable obj1, final Object obj2) {
		if (obj1 == null) return false;
		if (obj2 == null) return false;
		if (!(obj2 instanceof Comparable)) return false;
		if (obj1.getClass().equals(obj2.getClass())) 
			return (0 == obj1.compareTo(obj2));
		else 
			return false;
	}

	/**
	 * 
	 * @param a the array to examine
	 * @param length how far down the array to look
	 * @return true if the array is sorted and has no two elements equal to each other
	 */
	public static boolean isSortedAndUnique(Comparable[] a, final int length) {
		if (a.length == 0) return true;
		for (int i = 0; i < length-1; i++) {
			// a[i] should be less than a[i+1]
			final int c = a[i].compareTo(a[i+1]);
			if (c == 0) return false;
			if (c > 1) return false;
		}
		return true;
	}

	public static boolean allElementsUnique(Object[] a) {
		for (int i = 0; i < a.length; ++i) {
			for (int j = 0; j < a.length; ++j) {
				if (i != j) {
					if (a[i].equals(a[j])) return false;
				}
			}
		}
		return true;
	}

	/**
	 * @param a the array to get a string representation of
	 * @return
	 */
	public static String arrayToString(final Object[] a) {
		if (a.length == 0) return "{}";
		final StringBuffer b = new StringBuffer(a.length * 10);
		b.append("[");
		for (int i = 0; i < a.length-1; i++) {
			b.append(a[i].toString());
			b.append(", ");
		}
		b.append(a[a.length-1]);
		b.append("]");
		return b.toString();
	}
}
