package edu.mit.six825.bn.functiontable;


/**
 * Immutable and totally ordered (based on name).
 * Note that two FunctionVariables with the same name should have the equivalent domains,
 * and this class will throw RuntimeExceptions if it finds that this is not the case.
 * @author drayside
 */
public class FunctionVariable implements Comparable {
	public final String name;
	public final Domain domain;
	
	/**
	 * Construct a new FunctionVariable over the ComparableBoolean domain.
	 * @param n the name of the variable
	 */
	public FunctionVariable(String n) {
		this.name = n;
		this.domain = Domain.BOOLEAN_DOMAIN;
	}
	public FunctionVariable(String n, Domain d) {
		this.name = n;
		this.domain = d;
	}
	public int hashCode() {
		return name.hashCode() * domain.hashCode();
	}
	public boolean equals(final Object obj) {
		if (obj instanceof FunctionVariable) {
			final FunctionVariable other = (FunctionVariable)obj;
			if (!name.equals(other.name)) return false;
			assertDomainEquality(other);
			// passed all the tests
			return true;
		} return false;
	}
	public int compareTo(final Object obj) {
		// throw a ClassCastException if this isn't a FunctionVariable
		final FunctionVariable other = (FunctionVariable)obj;
		// sanity check: if the names are equal then the domains should be equal
		if (name.equals(other.name)) {
			assertDomainEquality(other);
			return 0;
		} else return name.compareTo(other.name);
	}
	private void assertDomainEquality(final FunctionVariable other) {
		if (!domain.equals(other.domain)) {
			// this is most certainly an error:  same name, different domain
			throw new RuntimeException("Two FunctionVariables named " + name + 
			" have different domains! " + domain.toString() + " and " + other.domain.toString());
		} 
	}
	public String toString() {
		return name;
	}
}
