package edu.mit.six825.bn.functiontable;


/**
 * Maps an Assignment to a double value.  Immutable.
 * @author drayside
 */
public class FunctionEntry implements Comparable {
	public final Assignment assignment;
	public final double value;
	public FunctionEntry (final Assignment a, final double d) {
		assignment = a;
		value = d;
	}
	public int compareTo(final Object obj) {
		final FunctionEntry other = (FunctionEntry)obj;
		if (!assignment.variables.equals(other.assignment.variables))
			throw new IllegalArgumentException("FunctionEntries must have the same variables in order to be compared.");
		final int c = assignment.compareTo(other.assignment);
		if (c == 0) {
			if (value < other.value) return -1;
			else if (value > other.value) return 1;
			else return 0;
		} else return c;
	}
	public boolean equals(final Object obj) {
		if (!(obj instanceof FunctionEntry)) return false;
		return (0 == compareTo(obj));
	}
	public int hashCode() {
		return assignment.hashCode() * (int)value;
	}
	public String toString() {
		final StringBuffer b = new StringBuffer(20*assignment.variables.size());
		b.append(assignment.toString());
		b.append(" = ");
		b.append(value);
		return b.toString();
	}
}
