package edu.mit.six825.bn.functiontable;

import java.util.Iterator;








/**
 * Maps Assignments to double values.
 * Contains a FunctionEntry for each point in the domain.
 * Functions are total over their domain.
 * Immutable.
 * @author drayside
 */
// TODO: restriction that rows sum to one over distinguished variable
public class Function {

	private final int[] accessCounters;

	public final FunctionVariableSet variables;

	/** this array is totally ordered */
	private final FunctionEntry[] entries;

	public Function(final FunctionConstructor c) {
		variables = c.getVariableSet();
		entries = new FunctionEntry[c.size()];
		for (int i = 0; i < entries.length; i++)
			entries[i] = c.next();
		accessCounters = new int[c.size()];
	}

	public Function(final FunctionVariableSet vars, final double[] values) {
		variables = vars;
		entries = new FunctionEntry[vars.cartesianProductSize()];
		for (Iterator i = vars.assignmentIterator(); i.hasNext(); ) {
			final Assignment a = (Assignment) i.next();
			final int index = a.computePosition();
			entries[index] = new FunctionEntry(a, values[index]);
		}
		accessCounters = new int[entries.length];
	}

	/**
	 * @param var
	 * @param values
	 */
	public Function(FunctionVariable var, double[] values) {
		this(new FunctionVariableSet(var), values);
	}

	private final static double CPT_TOLERANCE = 0.0001d;

	/**
	 * @param a an assignment that contains a superset of the variables in this function
	 * @return
	 */
	public double evaluate(final Assignment a) {
		if (!variables.isSubsetOf(a.variables))
			throw new IllegalArgumentException("incomplete assignment: " + a.toString() + " expected: " + variables.toString());

		final int pos = a.computePosition(variables);
		/*
		accessCounters[pos]++;
		if (accessCounters[pos] > 1)
			System.err.println("multiple access: " + toString() + " at position " + pos + " with counter " + accessCounters[pos] + " assignment " + a);
		*/
		return entries[pos].value;
	}

	/**
	 * @return sum of all the entries (usually used for normalizing)
	 */
	public double sum() {
		double sum = 0;
		for (int i = 0; i < entries.length; i++) {
			sum += entries[i].value;
		}
		return sum;
	}

	public String toString() {
		final StringBuffer r = new StringBuffer(1000);
		//r.append(variables.toString());
		for (int i = 0; i < entries.length; i++) {
			r.append('\n');
			r.append(entries[i].toString());
		}
		return r.toString();
	}

	public boolean equals(final Object obj) {
		if (!(obj instanceof Function)) return false;
		final Function other = (Function) obj;
		if (!other.variables.equals(variables)) return false;
		for (int i = 0; i < entries.length; i++) {
			if (!entries[i].equals(other.entries[i])) return false;
		}
		return true;
	}
	public int hashCode() {
		return variables.hashCode();
	}
}


