package edu.mit.six825.bn.functiontable;


/**
 * An index into a specific Domain.  Immutable.
 * @author drayside
 */
public class DomainIndex implements Comparable {
	public final Domain domain;
	public final int i;
	
	public DomainIndex(final Domain d, final int i) {
		this.domain = d;
		this.i = i;
	}
	public Comparable getValue() {
		return domain.getValue(this);
	}
	public int hashCode() {return i;}
	public boolean equals(Object obj) {
		if (obj instanceof DomainIndex) {
			final DomainIndex other = (DomainIndex)obj;
			return (this.i == other.i && domain.equals(other.domain));
		} return false;
	}

	public int compareTo(final Object obj) {
		final DomainIndex other = (DomainIndex)obj;
		if (!domain.equals(other.domain)) 
			throw new IllegalArgumentException("can't compare indices from different domains!");
		if (i < other.i) return -1;
		else if (i > other.i) return 1;
		else if (i == other.i) return 0;
		else throw new RuntimeException("weirdness in DomainIndex.compareTo()");
	}
	public String toString() {return domain.toString() + " at " + Integer.toString(i);}
}

