package edu.mit.six825.bn.functiontable;

/**
 * Basically the same as java.lang.Boolean, except
 * java.lang.Boolean is not Comparable, and we need that.
 * @author drayside
 */
public class ComparableBoolean implements Comparable {
	public final boolean value;

	public final static ComparableBoolean FALSE = new ComparableBoolean(false);
	public final static ComparableBoolean TRUE = new ComparableBoolean(true);

	private ComparableBoolean(final boolean v) {this.value = v;}

	public boolean equals(final Object obj) {
		if (obj instanceof ComparableBoolean) {
			return (value == ((ComparableBoolean)obj).value);
		} return false;
	}
	
	public int hashCode() {if (value) return 1; else return 0;}
	
	public int compareTo(final Object obj) {
		final ComparableBoolean other = (ComparableBoolean)obj;
		if (!value && other.value) return -1;
		else if (value && !other.value) return 1;
		else if (value == other.value) return 0;
		else throw new RuntimeException("shouldn't get here");
	}
	
	public String toString() {
		return Boolean.toString(value);
	}
}
