package edu.mit.six825.bn.functiontable;

import java.util.Iterator;



/**
 * Some basic functionality for reuse.
 * @author drayside
 */
public abstract class BaseFunctionConstructor implements FunctionConstructor {
	
	protected final FunctionVariableSet vars;
	protected final Iterator assignmentIterator;
	
	protected BaseFunctionConstructor(final FunctionVariableSet set) {
		super();
		this.vars = set;
		this.assignmentIterator = set.assignmentIterator();
	}

	public final FunctionVariableSet getVariableSet() { return vars; }

	public final int size() { return vars.cartesianProductSize(); }
	
	public final boolean hasNext() { return assignmentIterator.hasNext(); }

}
