/*
 * Created on Oct 7, 2003
 *
 */
package edu.mit.six825.bn.bayesnet;

import edu.mit.six825.bn.functiontable.Assignment;
import edu.mit.six825.bn.functiontable.Function;

/**
 * Provides some helpful functionality, like maintaining the evidence variables
 * that are needed for implementing BayesNet solvers. 
 * 
 * @author vineet
 */
public abstract class Solver {
	protected BayesNet _bn;
	protected Assignment _evidence;
	protected int reportingLevel = 0; // no reporting to System.out
	public final static int VERBOSE = 1;

	/**
	 * @param bn
	 */
	public Solver(BayesNet bn) {
		_bn = bn;
	}

	public Solver() {
		super();
	}

	public void setBayesNet(BayesNet bn) {
		this._bn = bn;
	}
	
	public void setReportingLevel(int r) {
		reportingLevel = r;
	}

	protected void report(final int msgLevel, final String msg) {
		if (msgLevel <= reportingLevel) System.out.println(msg);
	}

	public void setEvidence(Assignment e) {
		_evidence = e;
	}
	public Assignment getEvidence() {
		return _evidence;
	}

	abstract public Function query(BayesNetNode variable);

}
