package edu.mit.six825.bn.bayesnet;

import edu.mit.six825.bn.functiontable.Function;
import edu.mit.six825.bn.functiontable.FunctionVariable;
import edu.mit.six825.bn.functiontable.FunctionVariableSet;

/**
 * A variable in a BayesNet.  Immutable.
 * Comparable based on the underlying FunctionVariable.
 * @author drayside
 */
public class BayesNetNode implements Comparable {
	public final FunctionVariable var;
	public final BayesNetNodeSet parents;
	public final Function cpt;

	/**
	 * Constructs a new BayesNetNode.  Ensures that the Conditional Probability
	 * Table (cpt) for this node contains just this node and its parents.
	 * @param var FunctionVariable that this node represents
	 * @param parents BayesNetNodeSet of this node's parents
	 * @param cpt Conditional Probability Table for this node
	 */
	public BayesNetNode(
		final FunctionVariable var,
		final BayesNetNodeSet parents,
		final Function cpt) {
			if (!cpt.variables.equals(FunctionVariableSet.union(parents.getFunctionVariableSet(), var))) {
				throw new IllegalArgumentException("parents do not match cpt: \n" +
						"var == " + var + "\n"+
						"cpt.variables == " + cpt.variables +"\n"+
						"parents.getFunctionVariableSet() == " + parents.getFunctionVariableSet());
			}
			this.var = var;
			this.parents = parents;
			this.cpt = cpt;
		}
	public BayesNetNode(
		final String booleanFunctionVarName,
		final BayesNetNodeSet parents,
		final Function cpt) {
			this(new FunctionVariable(booleanFunctionVarName), parents, cpt);
		}


	public int compareTo(final Object obj) {
		final BayesNetNode other = (BayesNetNode)obj;
		return var.compareTo(other.var);
	}

	public boolean equals(final Object obj) {
		if (obj instanceof BayesNetNode)
			return (compareTo(obj) == 0);
		else return false;
	}
	public int hashCode() { return var.hashCode(); }

	public String toString() { return var.toString(); }

}
