/*
 * Decompiled with CFR 0.152.
 */
package uORCInterface;

import orc.AnalogInput;
import orc.DigitalInput;
import orc.DigitalOutput;
import orc.Motor;
import orc.Orc;
import orc.QuadratureEncoder;
import uORCInterface.OrcControlInterface;

public class OrcController
implements OrcControlInterface {
    private Orc orc;
    private Motor[] motorSet;
    private int[] portSet;
    protected static final int NUM_DIGITAL_IO = 16;
    private static final boolean[] DIGITAL_SETUP = new boolean[]{true, true, true, true, true, true, true, true, false, false, false, false, false, true, false, true};
    private DigitalInput[] dIn = new DigitalInput[16];
    private DigitalOutput[] dOut = new DigitalOutput[16];
    protected static final int MAX_ANALOG_PORT = 7;
    protected static final int MAX_PWM = 255;

    public OrcController(int[] nArray) {
        int n;
        this.orc = Orc.makeOrc();
        if (nArray.length > 2) {
            System.out.println("Too many Motors");
            System.exit(1);
        }
        this.motorSet = new Motor[nArray.length];
        this.portSet = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            this.checkPortRange(nArray[n]);
            this.motorSet[n] = new Motor(this.orc, nArray[n], false);
            this.portSet[n] = nArray[n];
        }
        for (n = 0; n < 16; ++n) {
            if (DIGITAL_SETUP[n]) {
                boolean bl = true;
                this.dIn[n] = new DigitalInput(this.orc, n, bl, false);
                continue;
            }
            this.dOut[n] = new DigitalOutput(this.orc, n);
        }
        System.out.println("uOrcBoard initialized...");
    }

    public double analogRead(int n) {
        if (n < 0 || n > 7) {
            System.out.println("Out of bound: the analog port must be 0~7");
            System.exit(1);
        }
        return new AnalogInput(this.orc, n).getVoltage();
    }

    public long clockReadSlave() {
        return this.orc.getStatus().utime;
    }

    public void motorSet(int n, int n2) {
        this.checkMotorRange(n);
        double d = 0.0;
        if (n2 < -255 || n2 > 255) {
            System.out.println("WARNING Out of bound: pwm should be [-255 255]");
            d = n2 / Math.abs(n2);
        } else {
            d = (double)n2 / 255.0;
        }
        this.motorSet[n].setPWM(d);
    }

    public void motorSlewWrite(int n, int n2) {
        this.checkMotorRange(n);
        this.motorSet[n].setSlewSeconds(n2);
    }

    public int readEncoder(int n) {
        this.checkMotorRange(n);
        return new QuadratureEncoder(this.orc, this.portSet[n], false).getPosition();
    }

    public int readVelocity(int n) {
        this.checkMotorRange(n);
        return (int)new QuadratureEncoder(this.orc, this.portSet[n], false).getVelocity();
    }

    public void servoWrite(int n, int n2) {
    }

    public void digitalSet(int n, boolean bl) {
        if (DIGITAL_SETUP[n]) {
            System.out.println("This port is NOT set for digital OUTPUT!!!");
            System.exit(1);
        } else {
            this.dOut[n].setValue(bl);
        }
    }

    public boolean digitalRead(int n) {
        if (!DIGITAL_SETUP[n]) {
            System.out.println("This port is NOT set for digital INPUT!!!");
            System.exit(1);
        }
        return this.dIn[n].getValue();
    }

    private void checkMotorRange(int n) {
        if (n < 0 || n > this.motorSet.length) {
            System.out.println("Out of bound: check the motor number");
            System.exit(1);
        }
    }

    private void checkPortRange(int n) {
        if (n < 0 || n > 2) {
            System.out.println("Out of bound: the port must be 0~2");
            System.exit(1);
        }
    }
}

