/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.io.DataInputStream;
import java.io.IOException;
import orc.OrcResponse;

public class OrcStatus {
    public long utime;
    public int statusFlags;
    public int debugCharsWaiting;
    public int[] analogInput = new int[13];
    public int[] analogInputFiltered = new int[13];
    public int[] analogInputFilterAlpha = new int[13];
    public int simpleDigitalValues;
    public int simpleDigitalDirections;
    public boolean[] motorEnable = new boolean[3];
    public int[] motorPWMactual = new int[3];
    public int[] motorPWMgoal = new int[3];
    public int[] motorSlewRaw = new int[3];
    public double[] motorSlewSeconds = new double[3];
    public int[] qeiPosition = new int[2];
    public int[] qeiVelocity = new int[2];
    public int[] fastDigitalMode = new int[8];
    public int[] fastDigitalConfig = new int[8];
    public long[] gyroIntegrator = new long[3];
    public int[] gyroIntegratorCount = new int[3];

    static final int readU16(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort() & 0xFFFF;
    }

    static final int readS16(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    static final int readU8(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readByte() & 0xFF;
    }

    public OrcStatus(OrcResponse orcResponse) throws IOException {
        int n;
        DataInputStream dataInputStream = orcResponse.ins;
        this.utime = orcResponse.utime;
        this.statusFlags = dataInputStream.readInt();
        this.debugCharsWaiting = OrcStatus.readU16(dataInputStream);
        for (n = 0; n < 13; ++n) {
            this.analogInput[n] = OrcStatus.readU16(dataInputStream);
            this.analogInputFiltered[n] = OrcStatus.readU16(dataInputStream);
            this.analogInputFilterAlpha[n] = OrcStatus.readU16(dataInputStream);
        }
        this.simpleDigitalValues = dataInputStream.readInt();
        this.simpleDigitalDirections = dataInputStream.readInt();
        for (n = 0; n < 3; ++n) {
            this.motorEnable[n] = OrcStatus.readU8(dataInputStream) != 0;
            this.motorPWMactual[n] = OrcStatus.readS16(dataInputStream);
            this.motorPWMgoal[n] = OrcStatus.readS16(dataInputStream);
            this.motorSlewRaw[n] = OrcStatus.readU16(dataInputStream);
            this.motorSlewSeconds[n] = 510.0 / (double)this.motorSlewRaw[n] / 1000.0 * 128.0;
        }
        for (n = 0; n < 2; ++n) {
            this.qeiPosition[n] = dataInputStream.readInt();
            this.qeiVelocity[n] = dataInputStream.readInt();
        }
        for (n = 0; n < 8; ++n) {
            this.fastDigitalMode[n] = OrcStatus.readU8(dataInputStream);
            this.fastDigitalConfig[n] = dataInputStream.readInt();
        }
        for (n = 0; n < 3; ++n) {
            this.gyroIntegrator[n] = dataInputStream.readLong();
            this.gyroIntegratorCount[n] = dataInputStream.readInt();
        }
    }
}

