/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import orc.OrcListener;
import orc.OrcResponse;
import orc.OrcStatus;

public class Orc {
    DatagramSocket sock;
    ReaderThread reader;
    InetAddress orcAddr;
    int nextTransactionId;
    static final int ORC_BASE_PORT = 2378;
    static final double MIN_TIMEOUT = 0.002;
    static final double MAX_TIMEOUT = 0.01;
    public static final int FAST_DIGIO_MODE_IN = 1;
    public static final int FAST_DIGIO_MODE_OUT = 2;
    public static final int FAST_DIGIO_MODE_SERVO = 3;
    double meanRTT = 0.002;
    public boolean verbose = false;
    HashMap<Integer, OrcResponse> transactionResponses = new HashMap();
    ArrayList<OrcListener> listeners = new ArrayList();

    public static void main(String[] stringArray) {
        Orc orc = Orc.makeOrc();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static Orc makeOrc() {
        return Orc.makeOrc("192.168.237.7");
    }

    public static Orc makeOrc(String string) {
        while (true) {
            try {
                return new Orc(Inet4Address.getByName(string));
            }
            catch (IOException iOException) {
                System.out.println("Exception creating Orc: " + iOException);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public Orc(InetAddress inetAddress) throws IOException {
        this.orcAddr = inetAddress;
        this.sock = new DatagramSocket();
        this.reader = new ReaderThread();
        this.reader.setDaemon(true);
        this.reader.start();
    }

    public void addListener(OrcListener orcListener) {
        this.listeners.add(orcListener);
    }

    OrcResponse doCommand(int n, byte[] byArray) {
        while (true) {
            try {
                return this.doCommandEx(n, byArray);
            }
            catch (IOException iOException) {
                System.out.println("ex: " + iOException);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrcResponse doCommandEx(int n, byte[] byArray) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        OrcResponse orcResponse = new OrcResponse();
        dataOutputStream.writeInt(216858626);
        Orc orc = this;
        synchronized (orc) {
            n2 = this.nextTransactionId++;
            this.transactionResponses.put(n2, orcResponse);
        }
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeLong(System.nanoTime() / 1000L);
        dataOutputStream.writeInt(n);
        if (byArray != null) {
            dataOutputStream.write(byArray);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, this.orcAddr, 2378 + (n >> 24 & 0xFF));
        long l = System.nanoTime();
        try {
            boolean bl;
            do {
                this.sock.send(datagramPacket);
                bl = orcResponse.waitForResponse(50 + (int)(10.0 * this.meanRTT));
                if (bl || !this.verbose) continue;
                System.out.println("Transaction timeout: " + n2 + ", timeout=" + this.meanRTT);
            } while (!bl);
            long l2 = System.nanoTime();
            double d = (double)(l2 - l) / 1.0E9;
            double d2 = 0.995;
            this.meanRTT = d2 * this.meanRTT + (1.0 - d2) * d;
            this.meanRTT = Math.min(Math.max(this.meanRTT, 0.002), 0.01);
            return orcResponse;
        }
        catch (IOException iOException) {
            this.transactionResponses.remove(n2);
            throw iOException;
        }
    }

    public OrcStatus getStatus() {
        while (true) {
            try {
                return new OrcStatus(this.doCommand(1, null));
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public byte[] i2cTransaction(int n, Object ... objectArray) {
        int n2;
        int n3;
        int n4;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write((byte)n);
        byteArrayOutputStream.write(1);
        assert ((objectArray.length & 1) == 0);
        assert (objectArray.length >= 2);
        int n5 = objectArray.length / 2;
        for (int i = 0; i < n5; ++i) {
            object = (byte[])objectArray[2 * i + 0];
            n4 = object == null ? 0 : ((byte[])object).length;
            n3 = (Integer)objectArray[2 * i + 1];
            byteArrayOutputStream.write((byte)n4);
            byteArrayOutputStream.write((byte)n3);
            for (n2 = 0; n2 < n4; ++n2) {
                byteArrayOutputStream.write((int)object[n2]);
            }
        }
        OrcResponse orcResponse = this.doCommand(20480, byteArrayOutputStream.toByteArray());
        assert (orcResponse.responded);
        object = new ByteArrayOutputStream();
        try {
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = orcResponse.ins.readByte() & 0xFF;
                if (n3 != 0) {
                    System.out.printf("Orc I2C error: code = %d\n", n3);
                }
                n2 = orcResponse.ins.readByte() & 0xFF;
                for (int i = 0; i < n2; ++i) {
                    object.write(orcResponse.ins.readByte());
                }
            }
            return object.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int[] spiTransaction(int n, int n2, int n3, int n4, int[] nArray) {
        n /= 1000;
        assert (n4 <= 16);
        assert (n2 == 0 || n2 == 1);
        assert (n3 == 0 || n3 == 1);
        assert (nArray.length <= 16);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(n4 | n2 << 6 | n3 << 7);
        byteArrayOutputStream.write(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            byteArrayOutputStream.write(nArray[i] >> 8 & 0xFF);
            byteArrayOutputStream.write(nArray[i] & 0xFF);
        }
        OrcResponse orcResponse = this.doCommand(16384, byteArrayOutputStream.toByteArray());
        assert (orcResponse.responded);
        int[] nArray2 = null;
        try {
            byte by = orcResponse.ins.readByte();
            assert (by == 0);
            int n5 = orcResponse.ins.readByte() & 0xFF;
            nArray2 = new int[n5];
            for (int i = 0; i < n5; ++i) {
                nArray2[i] = orcResponse.ins.readShort() & 0xFFFF;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return nArray2;
    }

    class ReaderThread
    extends Thread {
        ReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                byte[] byArray = new byte[1600];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                try {
                    OrcResponse orcResponse;
                    Orc.this.sock.receive(datagramPacket);
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 0, datagramPacket.getLength()));
                    int n = dataInputStream.readInt();
                    if (n != 216858625) {
                        System.out.println("bad signature");
                        continue;
                    }
                    int n2 = dataInputStream.readInt();
                    long l = dataInputStream.readLong();
                    int n3 = dataInputStream.readInt();
                    Orc orc = Orc.this;
                    synchronized (orc) {
                        orcResponse = Orc.this.transactionResponses.remove(n2);
                    }
                    if (orcResponse != null) {
                        orcResponse.ins = dataInputStream;
                        orcResponse.responseBuffer = byArray;
                        orcResponse.responseBufferOffset = 20;
                        orcResponse.responseBufferLength = datagramPacket.getLength();
                        orcResponse.utime = l;
                        orcResponse.responseId = n3;
                        orcResponse.gotResponse();
                        continue;
                    }
                    if (!Orc.this.verbose) continue;
                    System.out.println("Unexpected reply for transId: " + n2 + " (last issued: " + (Orc.this.nextTransactionId - 1) + ")");
                    continue;
                }
                catch (IOException iOException) {
                    System.out.println("Orc.ReaderThread Ex: " + iOException);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

