/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;
import orc.OrcStatus;

public class Motor {
    Orc orc;
    int port;
    boolean invert;

    public Motor(Orc orc, int n, boolean bl) {
        this.orc = orc;
        this.port = n;
        this.invert = bl;
    }

    public void idle() {
        this.orc.doCommand(4096, new byte[]{(byte)this.port, 0, 0, 0});
    }

    public void setPWM(double d) {
        assert (d >= -1.0 && d <= 1.0);
        int n = (int)(d * 255.0);
        if (this.invert) {
            n *= -1;
        }
        this.orc.doCommand(4096, new byte[]{(byte)this.port, 1, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)});
    }

    public double getCurrent() {
        OrcStatus orcStatus = this.orc.getStatus();
        double d = (double)orcStatus.analogInput[this.port + 8] / 65535.0 * 3.0;
        double d2 = d * 375.0 / 200.0;
        return d2;
    }

    public void setSlewSeconds(double d) {
        assert (d >= 0.0 && d < 120.0);
        d = Math.max(d, 0.001);
        double d2 = 0.51 / d * 128.0;
        int n = (int)d2;
        n = Math.max(n, 1);
        n = Math.min(n, 65535);
        this.orc.doCommand(4097, new byte[]{(byte)this.port, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)});
    }
}

