/*
 * Decompiled with CFR 0.152.
 */
package orc.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import orc.AX12Servo;
import orc.AX12Status;
import orc.Orc;
import orc.OrcStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AX12Demo {
    JFrame jf = new JFrame("AX12Demo");
    ArrayList<AX12Servo> servos;

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        orc.verbose = true;
        System.out.printf("Checking communication with Orc board...", new Object[0]);
        System.out.flush();
        OrcStatus os = orc.getStatus();
        System.out.println("good!");
        System.out.println("Scanning for AX12 servos...");
        ArrayList<AX12Servo> servos = new ArrayList<AX12Servo>();
        for (int id = 0; id < 254; ++id) {
            System.out.printf("%4d\r", id);
            System.out.flush();
            AX12Servo servo = new AX12Servo(orc, id);
            if (!servo.ping()) continue;
            System.out.printf("%d  found!\n", id);
            servos.add(servo);
        }
        if (servos.size() == 0) {
            System.out.println("No AX12 servos found.");
            System.exit(0);
        }
        new AX12Demo(servos);
    }

    public AX12Demo(ArrayList<AX12Servo> servos) {
        this.servos = servos;
        this.jf.setLayout(new GridLayout(servos.size(), 1));
        for (AX12Servo s : servos) {
            this.jf.add(new AX12Widget(s));
        }
        this.jf.setSize(800, 400);
        this.jf.setVisible(true);
    }

    class AX12Widget
    extends JPanel
    implements ChangeListener {
        AX12Servo servo;
        JSlider js;
        JLabel positionLabel = new JLabel("");
        JLabel speedLabel = new JLabel("");
        JLabel loadLabel = new JLabel("");
        JLabel voltageLabel = new JLabel("");
        JLabel tempLabel = new JLabel("");
        JLabel errorsLabel = new JLabel("");
        JSlider positionSlider = new JSlider(0, 300, 150);

        public AX12Widget(AX12Servo servo) {
            this.servo = servo;
            this.setBorder(BorderFactory.createTitledBorder("AX12 id " + servo.getId()));
            this.setLayout(new BorderLayout());
            JPanel jp = new JPanel();
            jp.setLayout(new GridLayout(6, 2));
            jp.add(new JLabel("Position"));
            jp.add(this.positionLabel);
            jp.add(new JLabel("Speed"));
            jp.add(this.speedLabel);
            jp.add(new JLabel("Load"));
            jp.add(this.loadLabel);
            jp.add(new JLabel("Voltage"));
            jp.add(this.voltageLabel);
            jp.add(new JLabel("Temp. (C)  "));
            jp.add(this.tempLabel);
            jp.add(new JLabel("Errors"));
            jp.add(this.errorsLabel);
            this.add((Component)jp, "East");
            this.add((Component)this.positionSlider, "Center");
            this.positionSlider.addChangeListener(this);
            new RunThread().start();
        }

        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == this.positionSlider) {
                this.servo.setGoalDegrees(this.positionSlider.getValue(), 0.3, 0.3);
            }
        }

        class RunThread
        extends Thread {
            RunThread() {
            }

            public void run() {
                while (true) {
                    AX12Status status = AX12Widget.this.servo.getStatus();
                    AX12Widget.this.positionLabel.setText(String.format("%.3f", status.positionDegrees));
                    AX12Widget.this.speedLabel.setText(String.format("%.3f", status.speed));
                    AX12Widget.this.loadLabel.setText(String.format("%.3f", status.load));
                    AX12Widget.this.voltageLabel.setText(String.format("%.3f", status.voltage));
                    AX12Widget.this.errorsLabel.setText(String.format("%02x", status.error_flags));
                    AX12Widget.this.tempLabel.setText(String.format("%.1f", status.temperature));
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }
    }
}

