/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import orc.OrcListener;
import orc.OrcResponse;
import orc.OrcStatus;
import orc.util.TimeSync;

public class Orc {
    DatagramSocket sock;
    ReaderThread reader;
    InetAddress orcAddr;
    int nextTransactionId;
    static final int ORC_BASE_PORT = 2378;
    static final double MIN_TIMEOUT = 0.002;
    static final double MAX_TIMEOUT = 0.01;
    public static final int FAST_DIGIO_MODE_IN = 1;
    public static final int FAST_DIGIO_MODE_OUT = 2;
    public static final int FAST_DIGIO_MODE_SERVO = 3;
    public static final int FAST_DIGIO_MODE_SLOW_PWM = 4;
    double meanRTT = 0.002;
    public boolean verbose = false;
    HashMap<Integer, OrcResponse> transactionResponses = new HashMap();
    ArrayList<OrcListener> listeners = new ArrayList();
    TimeSync ts = new TimeSync(1000000.0, 0L, 0.001, 0.5);

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        System.out.println("Version: " + orc.getVersion());
        System.out.println("Benchmarking...");
        long startmtime = System.currentTimeMillis();
        int niters = 1000;
        for (int i = 0; i < niters; ++i) {
            orc.getVersion();
        }
        long endmtime = System.currentTimeMillis();
        double iterspersec = (double)niters / ((double)(endmtime - startmtime) / 1000.0);
        System.out.printf("Iterations per second: %.1f\n", iterspersec);
    }

    public InetAddress getAddress() {
        return this.orcAddr;
    }

    public static Orc makeOrc() {
        return Orc.makeOrc("192.168.237.7");
    }

    public long toHostUtime(long uorcUtime) {
        return this.ts.getHostUtime(uorcUtime);
    }

    public String getVersion() {
        OrcResponse resp = this.doCommand(2, null);
        StringBuffer sb = new StringBuffer();
        try {
            byte b;
            while (resp.ins.available() > 0 && (b = (byte)resp.ins.read()) != 0) {
                sb.append((char)b);
            }
        }
        catch (IOException ex) {
            System.out.println("ex: " + ex);
        }
        return sb.toString();
    }

    public static Orc makeOrc(String hostname) {
        while (true) {
            try {
                return new Orc(Inet4Address.getByName(hostname));
            }
            catch (IOException ex) {
                System.out.println("Exception creating Orc: " + ex);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public Orc(InetAddress inetaddr) throws IOException {
        char c;
        this.orcAddr = inetaddr;
        this.sock = new DatagramSocket();
        this.reader = new ReaderThread();
        this.reader.setDaemon(true);
        this.reader.start();
        String version = this.getVersion();
        System.out.println("Connected to uorc with firmware " + version);
        if (!version.startsWith("v")) {
            System.out.println("Unrecognized firmware signature.");
        }
        int vers = 0;
        for (int idx = 1; idx < version.length() && Character.isDigit(version.charAt(idx)) && (c = version.charAt(idx)) != '-'; ++idx) {
            vers = vers * 10 + Character.digit(c, 10);
        }
        if (vers < 1) {
            System.out.println("Your firmware is too old.");
        }
    }

    public void addListener(OrcListener ol) {
        this.listeners.add(ol);
    }

    public OrcResponse doCommand(int commandId, byte[] payload) {
        while (true) {
            try {
                return this.doCommandEx(commandId, payload);
            }
            catch (IOException ex) {
                System.out.println("ERR: Orc ex: " + ex);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrcResponse doCommandEx(int commandId, byte[] payload) throws IOException {
        int transactionId;
        ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        DataOutputStream outs = new DataOutputStream(bouts);
        OrcResponse response = new OrcResponse();
        outs.writeInt(216858626);
        Orc orc = this;
        synchronized (orc) {
            transactionId = this.nextTransactionId++;
            this.transactionResponses.put(transactionId, response);
        }
        outs.writeInt(transactionId);
        outs.writeLong(System.nanoTime() / 1000L);
        outs.writeInt(commandId);
        if (payload != null) {
            outs.write(payload);
        }
        byte[] p = bouts.toByteArray();
        DatagramPacket packet = new DatagramPacket(p, p.length, this.orcAddr, 2378 + (commandId >> 24 & 0xFF));
        try {
            boolean okay;
            do {
                long starttime = System.nanoTime();
                this.sock.send(packet);
                okay = response.waitForResponse(50 + (int)(10.0 * this.meanRTT));
                if (!okay && this.verbose) {
                    System.out.printf("Transaction timeout: xid=%8d, command=%08x, timeout=%.4f\n", transactionId, commandId, this.meanRTT);
                }
                long endtime = System.nanoTime();
                double rtt = (double)(endtime - starttime) / 1.0E9;
                double alpha = 0.995;
                this.meanRTT = alpha * this.meanRTT + (1.0 - alpha) * rtt;
                this.meanRTT = Math.min(Math.max(this.meanRTT, 0.002), 0.01);
            } while (!okay);
            OrcResponse starttime = response;
            return starttime;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.transactionResponses.remove(transactionId);
        }
    }

    public OrcStatus getStatus() {
        while (true) {
            try {
                return new OrcStatus(this, this.doCommand(1, null));
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public byte[] i2cTransaction(int addr, Object ... os) {
        ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        bouts.write((byte)addr);
        bouts.write(1);
        assert ((os.length & 1) == 0);
        assert (os.length >= 2);
        int ntransactions = os.length / 2;
        for (int transaction = 0; transaction < ntransactions; ++transaction) {
            byte[] writebuf = (byte[])os[2 * transaction + 0];
            int writebuflen = writebuf == null ? 0 : writebuf.length;
            int readlen = (Integer)os[2 * transaction + 1];
            bouts.write((byte)writebuflen);
            bouts.write((byte)readlen);
            for (int i = 0; i < writebuflen; ++i) {
                bouts.write(writebuf[i]);
            }
        }
        OrcResponse resp = this.doCommand(20480, bouts.toByteArray());
        assert (resp.responded);
        ByteArrayOutputStream readData = new ByteArrayOutputStream();
        try {
            for (int transaction = 0; transaction < ntransactions; ++transaction) {
                int error = resp.ins.readByte() & 0xFF;
                if (error != 0) {
                    System.out.printf("Orc I2C error: code = %d\n", error);
                }
                int actualreadlen = resp.ins.readByte() & 0xFF;
                for (int i = 0; i < actualreadlen; ++i) {
                    readData.write(resp.ins.readByte());
                }
            }
            return readData.toByteArray();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public int[] spiTransaction(int slaveClk, int spo, int sph, int nbits, int[] writebuf) {
        slaveClk /= 1000;
        assert (nbits <= 16);
        assert (spo == 0 || spo == 1);
        assert (sph == 0 || sph == 1);
        assert (writebuf.length <= 16);
        ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        bouts.write(slaveClk >> 8 & 0xFF);
        bouts.write(slaveClk & 0xFF);
        bouts.write(nbits | spo << 6 | sph << 7);
        bouts.write(writebuf.length);
        for (int i = 0; i < writebuf.length; ++i) {
            bouts.write(writebuf[i] >> 8 & 0xFF);
            bouts.write(writebuf[i] & 0xFF);
        }
        OrcResponse resp = this.doCommand(16384, bouts.toByteArray());
        assert (resp.responded);
        int[] rx = null;
        try {
            byte status = resp.ins.readByte();
            assert (status == 0);
            int nwords = resp.ins.readByte() & 0xFF;
            rx = new int[nwords];
            for (int i = 0; i < nwords; ++i) {
                rx[i] = resp.ins.readShort() & 0xFFFF;
            }
        }
        catch (IOException ex) {
            return null;
        }
        return rx;
    }

    class ReaderThread
    extends Thread {
        ReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                byte[] packetBuffer = new byte[1600];
                DatagramPacket packet = new DatagramPacket(packetBuffer, packetBuffer.length);
                try {
                    OrcResponse sig;
                    Orc.this.sock.receive(packet);
                    DataInputStream ins = new DataInputStream(new ByteArrayInputStream(packetBuffer, 0, packet.getLength()));
                    int signature = ins.readInt();
                    if (signature != 216858625) {
                        System.out.println("bad signature");
                        continue;
                    }
                    int transId = ins.readInt();
                    long utimeOrc = ins.readLong();
                    int responseId = ins.readInt();
                    Orc.this.ts.update(System.currentTimeMillis() * 1000L, utimeOrc);
                    long utimeHost = Orc.this.toHostUtime(utimeOrc);
                    Orc orc = Orc.this;
                    synchronized (orc) {
                        sig = Orc.this.transactionResponses.remove(transId);
                    }
                    if (sig != null) {
                        sig.ins = ins;
                        sig.responseBuffer = packetBuffer;
                        sig.responseBufferOffset = 20;
                        sig.responseBufferLength = packet.getLength();
                        sig.utimeOrc = utimeOrc;
                        sig.utimeHost = utimeHost;
                        sig.responseId = responseId;
                        sig.gotResponse();
                        continue;
                    }
                    if (!Orc.this.verbose) continue;
                    System.out.println("Unexpected reply for transId: " + transId + " (last issued: " + (Orc.this.nextTransactionId - 1) + ")");
                    continue;
                }
                catch (IOException ex) {
                    System.out.println("Orc.ReaderThread Ex: " + ex);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex2) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

