/*
 * Decompiled with CFR 0.152.
 */
package MotorControlSolution;

import MotorControlSolution.VelocityController;

public abstract class WheelVelocityController
extends VelocityController {
    protected static final double MAX_PWM = 255.0;
    protected static final double MAX_ANGULAR_VELOCITY = 9.0;
    protected static final double ENCODER_RESOLUTION = 2000.0;
    protected static final double GEAR_RATIO = 65.5;
    protected double desiredAngularVelocity;
    protected double currentAngularVelocity;
    protected double encoderTicks;
    protected static final int FILTER_LEN = 4;
    protected double[] filter = new double[4];

    abstract double controlStep();

    public void setDesiredAngularVelocity(double d) {
        this.desiredAngularVelocity = d;
    }

    public double getDesiredAngularVelocity() {
        return this.desiredAngularVelocity;
    }

    public double computeRadiansPerTick() {
        double d = 0.0;
        d = 4.79632466196915E-5;
        return d;
    }

    public double computeEncoderInRadians() {
        double d = 0.0;
        d = this.computeRadiansPerTick() * this.encoderTicks;
        return d;
    }

    public double computeAngularVelocity() {
        double d = 0.0;
        if (this.sampleTime == 0.0) {
            d = 0.0;
        } else {
            d = this.computeEncoderInRadians() / this.sampleTime;
            for (int i = 0; i < 3; ++i) {
                this.filter[i + 1] = this.filter[i];
            }
            this.filter[0] = d;
            double d2 = 0.0;
            for (int i = 0; i < 4; ++i) {
                d2 += this.filter[i];
            }
            d = d2 / 4.0;
        }
        return d;
    }

    public void update(double d, double d2) {
        super.update(d);
        this.encoderTicks = d2;
        this.currentAngularVelocity = this.computeAngularVelocity();
    }
}

