/*
 * Decompiled with CFR 0.152.
 */
package MotorControlSolution;

import MotorControlSolution.RobotGraph;
import MotorControlSolution.RobotVelocityController;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Observable;
import uORCInterface.OrcController;

public class RobotBase
extends Observable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int[] MOTOR_PORT = new int[]{0, 1};
    public static final int[] ENCODER_PORT = new int[]{16, 18};
    protected static final int CONTROLLER_PERIOD_MS = 50;
    protected OrcController orc;
    protected double[] pwmGoal = new double[2];
    protected RobotVelocityController robotVelocityController;
    protected boolean motorsEnabled = false;
    protected boolean estopped = false;
    protected double lastTimeStamp;
    protected double totalSampleTime = 0.0;
    protected double startupTimeMS;
    protected long lastOrcTimeRaw;
    protected int[] lastEnc = new int[2];
    protected boolean logging = false;
    protected int file_idx;
    PrintWriter logWriter;

    public static int otherWheel(int n) {
        return n == 0 ? 1 : 0;
    }

    public RobotBase() {
        this.startupTimeMS = System.currentTimeMillis();
        this.orc = new OrcController(MOTOR_PORT);
        ControlLoopThread controlLoopThread = new ControlLoopThread();
        controlLoopThread.start();
        RobotGraph robotGraph = new RobotGraph();
        this.addObserver(robotGraph);
    }

    public void setRobotVelocityController(RobotVelocityController robotVelocityController) {
        this.robotVelocityController = robotVelocityController;
    }

    public RobotVelocityController getRobotVelocityController() {
        return this.robotVelocityController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPWMGoal(int n) {
        if (this.orc == null) {
            return 0;
        }
        double[] dArray = this.pwmGoal;
        synchronized (this.pwmGoal) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (int)this.pwmGoal[n];
        }
    }

    public void enableMotors(boolean bl) {
        this.motorsEnabled = bl;
    }

    public void setMotorSlewInterval(int n, double d) {
        int n2 = (int)(8.0 / d);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        System.err.println("TBD is this working? slew " + n + ": " + n2);
        this.orc.motorSlewWrite(n, n2);
    }

    public double analogRead(int n) {
        return this.orc.analogRead(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAndControl(double d, int n, int n2) {
        this.robotVelocityController.update(d, n, n2);
        double[] dArray = this.pwmGoal;
        synchronized (this.pwmGoal) {
            this.robotVelocityController.controlStep(this.pwmGoal);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    public boolean motorsEnabled() {
        return this.motorsEnabled;
    }

    public synchronized void estop() {
        this.estopped = true;
        this.enableMotors(false);
        this.orc.motorSet(0, 0);
        this.orc.motorSet(1, 0);
        this.stopVelocityLog();
    }

    public synchronized boolean estopped() {
        return this.estopped;
    }

    public void startVelocityLog() {
        if (this.logging) {
            return;
        }
        ++this.file_idx;
        String string = "dataLog" + this.file_idx + ".txt";
        try {
            this.logWriter = new PrintWriter(new FileWriter(new File(string)));
            this.logging = true;
        }
        catch (IOException iOException) {
            System.err.println("error starting velocity log" + iOException);
        }
    }

    public void stopVelocityLog() {
        if (!this.logging) {
            return;
        }
        this.logWriter.close();
        this.logging = false;
    }

    public void log(String string) {
        if (this.logging) {
            this.logWriter.println(string);
        }
    }

    class ControlLoopThread
    extends Thread {
        protected boolean firstUpdate = true;

        public ControlLoopThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.update();
            }
        }

        protected synchronized void update() {
            if (RobotBase.this.robotVelocityController == null) {
                return;
            }
            int n = RobotBase.this.orc.readEncoder(0);
            int n2 = RobotBase.this.orc.readEncoder(1);
            if (this.firstUpdate) {
                RobotBase.this.lastEnc[0] = n;
                RobotBase.this.lastEnc[1] = n2;
            }
            int n3 = n - RobotBase.this.lastEnc[0];
            int n4 = n2 - RobotBase.this.lastEnc[1];
            RobotBase.this.lastEnc[0] = n;
            RobotBase.this.lastEnc[1] = n2;
            RobotBase.this.setChanged();
            RobotBase.this.notifyObservers(new int[]{n3, -n4});
            RobotBase.this.clearChanged();
            long l = RobotBase.this.orc.clockReadSlave();
            long l2 = l >= RobotBase.this.lastOrcTimeRaw ? l - RobotBase.this.lastOrcTimeRaw : l + 65536L - RobotBase.this.lastOrcTimeRaw;
            RobotBase.this.lastOrcTimeRaw = l;
            double d = (double)l2 / 1000000.0;
            if (this.firstUpdate) {
                this.firstUpdate = false;
                return;
            }
            RobotBase.this.totalSampleTime += d;
            RobotBase.this.updateAndControl(d, n3, -n4);
            if (RobotBase.this.motorsEnabled) {
                RobotBase.this.orc.motorSet(0, (int)RobotBase.this.pwmGoal[0]);
                RobotBase.this.orc.motorSet(1, (int)(-RobotBase.this.pwmGoal[1]));
            } else {
                RobotBase.this.orc.motorSet(0, 0);
                RobotBase.this.orc.motorSet(1, 0);
            }
            RobotBase.this.log(RobotBase.this.totalSampleTime + " " + RobotBase.this.pwmGoal[0] + " " + RobotBase.this.pwmGoal[1] + " " + RobotBase.this.robotVelocityController.computeAngularVelocity(0) + " " + RobotBase.this.robotVelocityController.computeAngularVelocity(1) + " " + RobotBase.this.robotVelocityController.getDesiredAngularVelocity(0) + " " + RobotBase.this.robotVelocityController.getDesiredAngularVelocity(1));
        }
    }
}

