/*
 * Decompiled with CFR 0.152.
 */
package MotorControlSolution;

import MotorControlSolution.GraphPanel;
import MotorControlSolution.RobotBase;
import MotorControlSolution.RobotVelocityController;
import MotorControlSolution.RobotVelocityControllerBalanced;
import MotorControlSolution.WheelVelocityController;
import MotorControlSolution.WheelVelocityControllerPWM;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MotorControlGUI
extends JFrame
implements WindowListener {
    public static final int GAIN_RES = 100;
    public static final int DIFF_RES = 100;
    public static final int DES_RES = 100;
    DecimalFormat df = new DecimalFormat(){
        {
            this.setMaximumFractionDigits(2);
        }
    };
    protected RobotBase robot;
    protected RobotVelocityController rvc;
    protected JButton systemButton;
    protected JLabel systemLabel;
    protected boolean motorsEnabled = false;
    protected JButton dataLogButton;
    protected JLabel loggingLabel;
    protected boolean logging = false;
    protected Timer graphTimer;
    protected double diffV = 0.0;
    WheelPanel[] wheelPanel = new WheelPanel[2];

    public MotorControlGUI(RobotBase robotBase) {
        this.robot = robotBase;
        this.rvc = robotBase.getRobotVelocityController();
        if (this.rvc == null) {
            System.err.println("Must set a RobotVelocityController!");
            System.exit(-1);
        }
        Box box = Box.createVerticalBox();
        if (this.rvc instanceof RobotVelocityControllerBalanced) {
            box.add(this.setupRobotPanel());
            box.add(Box.createVerticalStrut(5));
        }
        this.wheelPanel[0] = new WheelPanel("Left", 0);
        this.wheelPanel[1] = new WheelPanel("Right", 1);
        Box box2 = Box.createHorizontalBox();
        box2.add(this.wheelPanel[0]);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.wheelPanel[1]);
        box.add(box2);
        JPanel jPanel = this.setupBottomPanel();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)box, "Center");
        container.add((Component)jPanel, "South");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setTitle("Motor Control GUI");
        this.setSize(900, 900);
        this.setVisible(true);
    }

    protected Component setupRobotPanel() {
        final JSlider jSlider = new JSlider(-1000, 1000, 0);
        final JTextField jTextField = new JTextField("0", 3);
        jSlider.setMajorTickSpacing(500);
        jSlider.setMinorTickSpacing(100);
        jSlider.setPaintTicks(true);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = MotorControlGUI.this.diffV;
                double d2 = MotorControlGUI.this.rvc.getDesiredAngularVelocity(0);
                MotorControlGUI.this.diffV = (double)jSlider.getValue() / 100.0;
                jTextField.setText(MotorControlGUI.this.df.format(MotorControlGUI.this.diffV));
                MotorControlGUI.this.wheelPanel[0].setWheelVelocity(d2 + (MotorControlGUI.this.diffV - d) / 2.0);
            }
        });
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = MotorControlGUI.this.diffV;
                double d2 = MotorControlGUI.this.rvc.getDesiredAngularVelocity(0);
                MotorControlGUI.this.diffV = Double.parseDouble(jTextField.getText());
                jSlider.setValue((int)(MotorControlGUI.this.diffV * 100.0));
                MotorControlGUI.this.wheelPanel[0].setWheelVelocity(d2 + (MotorControlGUI.this.diffV - d) / 2.0);
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Diff Vel: "));
        box.add(jSlider);
        box.add(jTextField);
        box.add(new JLabel("rad/s"));
        final JSlider jSlider2 = new JSlider(-3000, 3000, 0);
        final JTextField jTextField2 = new JTextField("0", 3);
        jSlider2.setMajorTickSpacing(1000);
        jSlider2.setMinorTickSpacing(500);
        jSlider2.setPaintTicks(true);
        jTextField2.setMaximumSize(jTextField2.getPreferredSize());
        double d = this.rvc.getGain();
        jSlider2.setValue((int)(d * 100.0));
        jTextField2.setText(this.df.format(d));
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (double)jSlider2.getValue() / 100.0;
                jTextField2.setText(MotorControlGUI.this.df.format(d));
                MotorControlGUI.this.rvc.setGain(d);
            }
        });
        jTextField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = Double.parseDouble(jTextField2.getText());
                jSlider2.setValue((int)(d * 100.0));
                MotorControlGUI.this.rvc.setGain(d);
            }
        });
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("RVC Gain : "));
        box2.add(jSlider2);
        box2.add(jTextField2);
        Box box3 = Box.createVerticalBox();
        box3.add(box);
        box3.add(box2);
        box3.setBorder(new TitledBorder(new EtchedBorder(), "Whole Robot"));
        return box3;
    }

    protected JPanel setupBottomPanel() {
        this.systemButton = new JButton("Start");
        this.systemButton.setPreferredSize(new Dimension(90, 20));
        this.systemLabel = new JLabel("System halted", 0);
        this.systemLabel.setForeground(Color.yellow);
        this.systemButton.addActionListener(new SystemButtonListener());
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.add(this.systemButton);
        jPanel.add(this.systemLabel);
        jPanel.setBackground(Color.black);
        this.loggingLabel = new JLabel();
        this.loggingLabel.setForeground(Color.yellow);
        this.dataLogButton = new JButton("Start Log");
        this.dataLogButton.setPreferredSize(new Dimension(90, 20));
        this.dataLogButton.addActionListener(new DataLogListener());
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.add(this.dataLogButton);
        jPanel2.add(this.loggingLabel);
        jPanel2.setBackground(Color.black);
        Box box = Box.createVerticalBox();
        box.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createBevelBorder(0)));
        box.add(jPanel2);
        box.add(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)box, "Center");
        return jPanel3;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.robot.estop();
        System.out.println("******* window closing ********");
        this.dispose();
        System.exit(0);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    class WheelPanel
    extends JPanel {
        protected int wheel;
        protected WheelVelocityController wvc;
        protected Box displayBox;
        protected WheelPanelListener wpListener;
        protected JRadioButton manualRadioButton;
        protected JRadioButton stepRadioButton;
        protected JRadioButton sineRadioButton;
        protected Timer inputFunctionTimer;
        protected JSlider desiredSlider;
        protected JTextField desiredValue;
        protected JPanel desiredSliderPanel;
        protected JLabel desiredLabel;
        protected JLabel desiredUnitsLabel;
        protected JSlider gainSlider;
        protected JTextField gainValue;
        protected JPanel gainPanel;
        protected JLabel pwmValue;
        protected JLabel angularVelocityValue;
        protected GraphPanel graphPanel;
        protected Timer graphTimer;

        public WheelPanel(String string, int n) {
            super(new BorderLayout());
            this.manualRadioButton = new JRadioButton("Manual", false);
            this.stepRadioButton = new JRadioButton("Step", false);
            this.sineRadioButton = new JRadioButton("Sine", false);
            this.desiredSlider = new JSlider(-25500, 25500, 0);
            this.desiredValue = new JTextField("0", 3);
            this.desiredSliderPanel = new JPanel(new FlowLayout(3));
            this.desiredLabel = new JLabel("");
            this.desiredUnitsLabel = new JLabel("");
            this.gainSlider = new JSlider(-3000, 3000, 0);
            this.gainValue = new JTextField("1.00", 5);
            this.gainPanel = new JPanel(new FlowLayout(3));
            this.wheel = n;
            this.wvc = MotorControlGUI.this.rvc.getWheelVelocityController(n);
            String string2 = string + " Wheel: " + this.wvc.getName();
            this.wpListener = new WheelPanelListener();
            this.displayBox = Box.createVerticalBox();
            this.displayBox.setPreferredSize(new Dimension(400, 200));
            this.displayBox.add(Box.createVerticalStrut(10));
            this.addChoicePanel();
            this.addChoiceActionListeners();
            this.addDesiredSliderPanel();
            this.addGainSliderPanel();
            this.pwmValue = new JLabel();
            this.angularVelocityValue = new JLabel();
            this.addReadOnlyValuePanel("PWM:", this.pwmValue, "");
            this.addReadOnlyValuePanel("Ang Vel:", this.angularVelocityValue, "rad/s");
            this.graphPanel = new GraphPanel(400, 200, 200);
            this.displayBox.add(this.graphPanel);
            this.setBorder(new TitledBorder(new EtchedBorder(), string2));
            this.add((Component)this.displayBox, "Center");
            this.inputFunctionTimer = new Timer(50, new InputFunctionActionListener());
            this.inputFunctionTimer.start();
            this.graphTimer = new Timer(50, new GraphListener());
            this.graphTimer.start();
        }

        protected void addReadOnlyValuePanel(String string, JLabel jLabel, String string2) {
            JPanel jPanel = new JPanel(new FlowLayout(3));
            jPanel.add(new JLabel(string));
            jPanel.add(jLabel);
            jPanel.add(new JLabel(string2));
            this.displayBox.add(jPanel);
            this.displayBox.add(Box.createVerticalStrut(5));
        }

        protected void addDesiredSliderPanel() {
            this.desiredSlider.setMajorTickSpacing(2500);
            this.desiredSlider.setMinorTickSpacing(500);
            this.desiredSlider.setPaintTicks(true);
            this.desiredSlider.addChangeListener(new DesiredSliderListener());
            this.desiredValue.addActionListener(this.wpListener);
            this.desiredSliderPanel.add(this.desiredLabel);
            this.desiredSliderPanel.add(this.desiredSlider);
            this.desiredSliderPanel.add(this.desiredValue);
            this.desiredSliderPanel.add(this.desiredUnitsLabel);
            this.displayBox.add(this.desiredSliderPanel);
            this.displayBox.add(Box.createVerticalStrut(5));
        }

        protected void addGainSliderPanel() {
            this.gainSlider.setMajorTickSpacing(1000);
            this.gainSlider.setMinorTickSpacing(500);
            this.gainSlider.setPaintTicks(true);
            double d = this.wvc.getGain();
            this.gainSlider.setValue((int)(d * 100.0));
            this.gainValue.setText(MotorControlGUI.this.df.format(d));
            this.gainSlider.addChangeListener(new GainSliderListener());
            this.gainValue.addActionListener(this.wpListener);
            this.gainPanel.add(new JLabel("Wheel Gain: "));
            this.gainPanel.add(this.gainSlider);
            this.gainPanel.add(this.gainValue);
            this.displayBox.add(this.gainPanel);
            this.displayBox.add(Box.createVerticalStrut(5));
        }

        protected void addChoicePanel() {
            JPanel jPanel = new JPanel(new FlowLayout(3));
            jPanel.add(new JLabel("Input Function: "));
            if (this.wvc instanceof WheelVelocityControllerPWM) {
                jPanel.add(this.manualRadioButton);
            } else {
                jPanel.add(this.manualRadioButton);
                jPanel.add(this.stepRadioButton);
                jPanel.add(this.sineRadioButton);
            }
            this.manualRadioButton.setSelected(true);
            this.manualRadioButtonAction();
            this.displayBox.add(jPanel);
        }

        protected void manualRadioButtonAction() {
            this.manualRadioButton.setSelected(true);
            this.stepRadioButton.setSelected(false);
            this.sineRadioButton.setSelected(false);
            this.desiredSlider.setEnabled(true);
            this.desiredValue.setEnabled(true);
            if (this.wvc instanceof WheelVelocityControllerPWM) {
                this.desiredLabel.setText("Desired PWM");
                this.desiredUnitsLabel.setText("PWM");
                this.desiredSlider.setMinimum(-25500);
                this.desiredSlider.setMaximum(25500);
                this.desiredSlider.setValue(0);
                this.desiredSlider.setMajorTickSpacing(2500);
                this.desiredSlider.setMinorTickSpacing(500);
                this.gainSlider.setEnabled(false);
                this.gainValue.setEnabled(false);
            } else {
                this.desiredLabel.setText("Desired Velocity");
                this.desiredUnitsLabel.setText("rad/s");
                this.desiredSlider.setMinimum(-1000);
                this.desiredSlider.setMaximum(1000);
                this.desiredSlider.setValue(0);
                this.desiredSlider.setMajorTickSpacing(500);
                this.desiredSlider.setMinorTickSpacing(100);
                this.gainSlider.setEnabled(true);
                this.gainValue.setEnabled(true);
            }
        }

        protected void addChoiceActionListeners() {
            this.manualRadioButton.addActionListener(this.wpListener);
            this.manualRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WheelPanel.this.manualRadioButtonAction();
                }
            });
            this.stepRadioButton.addActionListener(this.wpListener);
            this.stepRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WheelPanel.this.manualRadioButton.setSelected(false);
                    WheelPanel.this.stepRadioButton.setSelected(true);
                    WheelPanel.this.sineRadioButton.setSelected(false);
                    WheelPanel.this.desiredSlider.setEnabled(false);
                    WheelPanel.this.desiredValue.setEnabled(false);
                    WheelPanel.this.gainSlider.setEnabled(true);
                    WheelPanel.this.gainValue.setEnabled(true);
                }
            });
            this.sineRadioButton.addActionListener(this.wpListener);
            this.sineRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WheelPanel.this.manualRadioButton.setSelected(false);
                    WheelPanel.this.stepRadioButton.setSelected(false);
                    WheelPanel.this.sineRadioButton.setSelected(true);
                    WheelPanel.this.desiredSlider.setEnabled(false);
                    WheelPanel.this.desiredValue.setEnabled(false);
                    WheelPanel.this.gainSlider.setEnabled(true);
                    WheelPanel.this.gainValue.setEnabled(true);
                }
            });
        }

        protected void setWheelVelocity(double d) {
            if (MotorControlGUI.this.rvc instanceof RobotVelocityControllerBalanced) {
                int n = RobotBase.otherWheel(this.wheel);
                double d2 = d + MotorControlGUI.this.diffV * (this.wheel == 0 ? -1.0 : 1.0);
                WheelPanel wheelPanel = MotorControlGUI.this.wheelPanel[n];
                wheelPanel.desiredSlider.setValue((int)(d2 * 100.0));
                wheelPanel.desiredValue.setText(MotorControlGUI.this.df.format(d2));
                double d3 = this.wheel == 0 ? d : d2;
                double d4 = this.wheel == 1 ? d : d2;
                MotorControlGUI.this.rvc.setDesiredAngularVelocity(d3, d4);
            } else {
                this.desiredSlider.setValue((int)(d * 100.0));
                this.desiredValue.setText(MotorControlGUI.this.df.format(d));
                MotorControlGUI.this.rvc.setDesiredAngularVelocity(this.wheel, d);
            }
        }

        protected void setGain(double d) {
            this.gainSlider.setValue((int)(d * 100.0));
            this.gainValue.setText(MotorControlGUI.this.df.format(d));
            if (MotorControlGUI.this.rvc instanceof RobotVelocityControllerBalanced) {
                WheelPanel wheelPanel = MotorControlGUI.this.wheelPanel[RobotBase.otherWheel(this.wheel)];
                wheelPanel.gainSlider.setValue((int)(d * 100.0));
                wheelPanel.gainValue.setText(MotorControlGUI.this.df.format(d));
                wheelPanel.wvc.setGain(d);
            }
            this.wvc.setGain(d);
        }

        class GainSliderListener
        implements ChangeListener {
            GainSliderListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                WheelPanel.this.setGain((double)WheelPanel.this.gainSlider.getValue() / 100.0);
            }
        }

        class DesiredSliderListener
        implements ChangeListener {
            DesiredSliderListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                WheelPanel.this.setWheelVelocity((double)WheelPanel.this.desiredSlider.getValue() / 100.0);
            }
        }

        class WheelPanelListener
        implements ActionListener {
            WheelPanelListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                WheelPanel.this.setGain(Double.parseDouble(WheelPanel.this.gainValue.getText()));
                WheelPanel.this.setWheelVelocity(Double.parseDouble(WheelPanel.this.desiredValue.getText()));
            }
        }

        class InputFunctionActionListener
        implements ActionListener {
            protected double t = 0.0;
            protected double v = 0.0;
            protected double vSign = 1.0;

            InputFunctionActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (WheelPanel.this.sineRadioButton.isSelected()) {
                    this.v = 8.0 * Math.sin(this.t);
                    this.t += 0.07853981633974483;
                } else if (WheelPanel.this.stepRadioButton.isSelected()) {
                    if (this.t > 100.0) {
                        this.v += 3.0 * this.vSign;
                        if (this.v > 10.0) {
                            this.vSign = -1.0;
                        }
                        if (this.v < -10.0) {
                            this.vSign = 1.0;
                        }
                        this.t = 0.0;
                    } else {
                        this.t += 1.0;
                    }
                }
                if (!WheelPanel.this.manualRadioButton.isSelected()) {
                    WheelPanel.this.setWheelVelocity(this.v);
                }
            }
        }

        class GraphListener
        implements ActionListener {
            GraphListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                WheelPanel.this.pwmValue.setText(Integer.toString(MotorControlGUI.this.robot.getPWMGoal(WheelPanel.this.wheel)));
                double d = MotorControlGUI.this.rvc.computeAngularVelocity(WheelPanel.this.wheel);
                WheelPanel.this.angularVelocityValue.setText(MotorControlGUI.this.df.format(d));
                WheelPanel.this.graphPanel.log(d);
            }
        }
    }

    class SystemButtonListener
    implements ActionListener {
        SystemButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!MotorControlGUI.this.motorsEnabled) {
                MotorControlGUI.this.systemButton.setText("Stop");
                MotorControlGUI.this.systemLabel.setText("System running");
                MotorControlGUI.this.robot.enableMotors(true);
                MotorControlGUI.this.motorsEnabled = true;
            } else {
                MotorControlGUI.this.systemButton.setText("Start");
                MotorControlGUI.this.systemLabel.setText("System halted");
                MotorControlGUI.this.robot.enableMotors(false);
                MotorControlGUI.this.motorsEnabled = false;
            }
        }
    }

    class DataLogListener
    implements ActionListener {
        DataLogListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!MotorControlGUI.this.logging) {
                MotorControlGUI.this.dataLogButton.setText("Stop Log");
                MotorControlGUI.this.loggingLabel.setText("Logging data . . .");
                MotorControlGUI.this.robot.startVelocityLog();
                MotorControlGUI.this.logging = true;
            } else {
                MotorControlGUI.this.robot.stopVelocityLog();
                MotorControlGUI.this.dataLogButton.setText("Start Log");
                MotorControlGUI.this.loggingLabel.setText("");
                MotorControlGUI.this.logging = false;
            }
        }
    }
}

