/*
 * Decompiled with CFR 0.152.
 */
package MotorControlSolution;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class GraphPanel
extends JPanel {
    private int labelOffsetX = 20;
    private int labelOffsetY = 20;
    private int graphSizeX;
    private int graphSizeY;
    private int originX;
    private int originY;
    private double xScale;
    private double yScale;
    private double[] data;
    private double maxY;
    private double minY;
    public boolean drawAxes = true;
    public boolean drawPoints = false;

    public GraphPanel(int n, int n2, int n3) {
        super.setPreferredSize(new Dimension(n, n2));
        this.graphSizeX = n - this.labelOffsetX;
        this.graphSizeY = n2 - this.labelOffsetY;
        this.originX = this.labelOffsetX;
        this.originY = this.graphSizeY / 2;
        this.maxY = 10.0;
        this.minY = -10.0;
        this.data = new double[n3];
        this.xScale = (double)this.graphSizeX / (double)n3;
        this.yScale = (double)this.graphSizeY / (this.maxY - this.minY);
        this.clearGraph();
    }

    public void clearGraph() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0;
        }
    }

    public void log(double d) {
        for (int i = 0; i < this.data.length - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        this.data[this.data.length - 1] = d;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.black);
        if (this.drawAxes) {
            graphics.drawLine(this.labelOffsetX, this.graphSizeY, this.labelOffsetX, 0);
            graphics.drawLine(this.originX, this.originY, this.labelOffsetX + this.graphSizeX, this.originY);
            graphics.drawString("t", this.labelOffsetX + this.graphSizeX / 2, this.labelOffsetY / 2 + this.graphSizeY);
            graphics.drawString("v", 0, this.graphSizeY / 2);
            graphics.drawString("0", this.labelOffsetX - 10, this.originY + 5);
            graphics.drawString(" " + (int)this.maxY, this.labelOffsetX - 20, 5);
            graphics.drawString("" + (int)this.minY, this.labelOffsetX - 20, this.graphSizeY + 5);
            graphics.setColor(Color.gray);
            for (n = -8; n <= 8; n += 2) {
                if (n == 0) continue;
                graphics.drawString("" + n, this.labelOffsetX - 10, this.originY + 5 - (int)((double)n * this.yScale));
                graphics.drawLine(this.originX, this.originY - (int)((double)n * this.yScale), this.labelOffsetX + this.graphSizeX, this.originY - (int)((double)n * this.yScale));
            }
        }
        graphics.setColor(Color.red);
        for (n = 0; n < this.data.length - 1; ++n) {
            if (this.drawPoints) {
                graphics.drawLine(this.originX + (int)((double)n * this.xScale), this.originY - (int)(this.data[n] * this.yScale), this.originY + (int)((double)n * this.xScale), this.originY - (int)(this.data[n] * this.yScale));
                continue;
            }
            graphics.drawLine(this.originX + (int)((double)n * this.xScale), this.originY - (int)(this.data[n] * this.yScale), this.originX + (int)((double)(n + 1) * this.xScale), this.originY - (int)(this.data[n + 1] * this.yScale));
        }
    }
}

