/*
 * Decompiled with CFR 0.152.
 */
package orc.examples;

import orc.Motor;
import orc.Orc;
import orc.util.GamePad;

public class GamePadDrive {
    public static void main(String[] args) {
        GamePad gp = new GamePad();
        Orc orc = Orc.makeOrc();
        boolean flipLeft = args.length > 2 ? Boolean.parseBoolean(args[1]) : false;
        boolean flipRight = args.length > 2 ? Boolean.parseBoolean(args[2]) : true;
        boolean flipMotors = args.length > 3 ? Boolean.parseBoolean(args[3]) : false;
        Motor leftMotor = new Motor(orc, flipMotors ? 1 : 0, flipLeft);
        Motor rightMotor = new Motor(orc, flipMotors ? 0 : 1, flipRight);
        System.out.println("flipLeft: " + flipLeft + ", flipRight: " + flipRight + ", flipMotors: " + flipMotors);
        System.out.println("Hit any gamepad button to begin.");
        gp.waitForAnyButtonPress();
        System.out.printf("%15s %15s %15s %15s\n", "left", "right", "left current", "right current");
        while (true) {
            double left = 0.0;
            double right = 0.0;
            double fwd = -gp.getAxis(3);
            double lr = gp.getAxis(2);
            left = fwd - lr;
            right = fwd + lr;
            double max = Math.max(Math.abs(left), Math.abs(right));
            if (max > 1.0) {
                left /= max;
                right /= max;
            }
            System.out.printf("%15f %15f %15f %15f\r", left, right, leftMotor.getCurrent(), rightMotor.getCurrent());
            leftMotor.setPWM(left);
            rightMotor.setPWM(right);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException ex) {
            }
        }
    }
}

