/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;

public class SRF02 {
    Orc orc;
    int i2caddr;
    static final int DEFAULT_I2C_ADDR = 112;
    static double SOUND_METERS_PER_SEC = 343.0;

    public SRF02(Orc orc, int i2caddr) {
        this.orc = orc;
        this.i2caddr = i2caddr;
    }

    public SRF02(Orc orc) {
        this(orc, 112);
    }

    public void ping() {
        byte[] resp = this.orc.i2cTransaction(this.i2caddr, new byte[]{0, 82}, 0);
    }

    public double readTime() {
        byte[] resp = this.orc.i2cTransaction(this.i2caddr, new byte[]{2}, 4);
        int usecs = ((resp[0] & 0xFF) << 8) + (resp[1] & 0xFF);
        int minusecs = ((resp[2] & 0xFF) << 8) + (resp[3] & 0xFF);
        System.out.printf("%15d %15d\n", usecs, minusecs);
        return (double)usecs / 1000000.0;
    }

    public double readRange() {
        return this.readTime() * SOUND_METERS_PER_SEC / 2.0;
    }

    public double measure() {
        this.ping();
        try {
            Thread.sleep(70L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.readRange();
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        SRF02 srf = new SRF02(orc);
        while (true) {
            System.out.printf("%15f m\n", srf.measure());
        }
    }
}

