/*
 * Decompiled with CFR 0.152.
 */
package maslab.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipExtractor {
    static final int BUFFER_SIZE = 100000;
    HashMap<String, Integer> htSizes;
    String zipfile;

    public ZipExtractor(String zipfile) throws IOException {
        this.zipfile = zipfile;
        this.htSizes = new HashMap();
        ZipFile zf = new ZipFile(zipfile);
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            this.htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
        }
        zf.close();
    }

    public byte[] getResource(String name) throws IOException {
        FileInputStream fis = new FileInputStream(this.zipfile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ZipInputStream zis = new ZipInputStream(bis);
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            if (!ze.getName().equals(name)) continue;
            int size = this.htSizes.get(name);
            byte[] result = new byte[size];
            for (int count = 0; count < size; count += zis.read(result, count, size - count)) {
            }
            return result;
        }
        return null;
    }

    public void saveResource(String name, String filename) throws IOException {
        byte[] data = this.getResource(name);
        FileOutputStream fos = new FileOutputStream(filename);
        fos.write(data);
        fos.close();
    }
}

