/*
 * Decompiled with CFR 0.152.
 */
package maslab.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import maslab.util.Logger;

public class ImageUtil {
    static Logger log = new Logger("ImageUtil");

    public static BufferedImage convertImage(BufferedImage in, int type) {
        if (in.getType() == type) {
            return in;
        }
        log.warn("Performing slow image type conversion");
        int w = in.getWidth();
        int h = in.getHeight();
        BufferedImage out = new BufferedImage(w, h, type);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                out.setRGB(x, y, in.getRGB(x, y));
            }
        }
        return out;
    }

    public static BufferedImage ditherImage(BufferedImage in) {
        int gray;
        BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), 1);
        int width = in.getWidth();
        int height = in.getHeight();
        int[] d = in.getRGB(0, 0, width, height, null, 0, width);
        int[] dout = new int[width * height];
        int p = 0;
        int sum = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int c = d[p];
                gray = (int)(0.299 * (double)((c & 0xFF0000) >> 16) + 0.587 * (double)((c & 0xFF00) >> 8) + 0.114 * (double)(c & 0xFF));
                sum += gray;
                d[p] = gray;
                ++x;
                ++p;
            }
        }
        int thresh = sum / (width * height) / 2;
        p = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                gray = d[p];
                int bw = 0;
                if (gray >= thresh) {
                    bw = 255;
                }
                dout[p] = bw | bw << 8 | bw << 16 | 0xFF000000;
                int err = gray - bw;
                if (x < width - 1) {
                    int n = p + 1;
                    d[n] = d[n] + err * 7 / 16;
                }
                if (x > 0 && y < height - 1) {
                    int n = p - 1 + width;
                    d[n] = d[n] + err * 3 / 16;
                }
                if (y < height - 1) {
                    int n = p + width;
                    d[n] = d[n] + err * 5 / 16;
                }
                if (x < width - 1 && y < height - 1) {
                    int n = p + width + 1;
                    d[n] = d[n] + err * 1 / 16;
                }
                ++x;
                ++p;
            }
        }
        out.setRGB(0, 0, width, height, dout, 0, width);
        return out;
    }

    public static BufferedImage downSample(BufferedImage in, int interval) {
        int w = in.getWidth();
        int h = in.getHeight();
        int sw = w / interval;
        int sh = h / interval;
        in = ImageUtil.convertImage(in, 1);
        BufferedImage out = new BufferedImage(sw, sh, 1);
        int[] inbuf = ((DataBufferInt)in.getRaster().getDataBuffer()).getData();
        int[] outbuf = ((DataBufferInt)out.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int spos = 0;
        int y = 0;
        int sy = 0;
        while (sy < sh) {
            int x = 0;
            int sx = 0;
            while (sx < sw) {
                outbuf[spos] = inbuf[pos + x];
                ++sx;
                x += interval;
                ++spos;
            }
            ++sy;
            y += interval;
            pos += w;
        }
        return out;
    }

    public static BufferedImage cloneImage(BufferedImage in) {
        int type = in.getType();
        int w = in.getWidth();
        int h = in.getHeight();
        BufferedImage out = new BufferedImage(w, h, type);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                out.setRGB(x, y, in.getRGB(x, y));
            }
        }
        return out;
    }
}

