/*
 * Decompiled with CFR 0.152.
 */
package maslab.test;

import maslab.orc.Orc;

public class TimeTest {
    public static void main(String[] args) {
        Orc orc;
        try {
            orc = new Orc();
        }
        catch (Exception ex) {
            return;
        }
        orc.lcdConsoleHome();
        orc.lcdConsoleWrite("hello, world.*");
        orc.setCacheLifetime(-1);
        long voffset = 0L;
        long vvoffset = 0L;
        orc.pinModeWrite(16, Orc.PinMode.QUADPHASE);
        orc.pinModeWrite(17, Orc.PinMode.QUADPHASE);
        long lastqp = 0L;
        long lasttime = 0L;
        long systemoffset = System.currentTimeMillis();
        long mastertickslast = orc.clockReadMaster();
        long slavetickslast = orc.clockReadSlave();
        double systemtime = 0.0;
        double mastertime = 0.0;
        double slavetime = 0.0;
        while (true) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            systemtime = System.currentTimeMillis() - systemoffset;
            long masterticks = orc.clockReadMaster();
            long slaveticks = orc.clockReadSlave();
            mastertickslast = masterticks;
            slavetickslast = slaveticks;
            double mastererror = ((mastertime += (double)Orc.diff16(masterticks, mastertickslast) / 4.0) - systemtime) / systemtime;
            double slaveerror = ((slavetime += (double)Orc.diff16(slaveticks, slavetickslast) / 4.0) - systemtime) / systemtime;
            System.out.println(String.format("%8.0f %8.0f (%2.2f%%) %8.0f (%2.2f%%)", systemtime, mastertime, mastererror * 100.0, slavetime, slaveerror * 100.0));
        }
    }
}

