/*
 * Decompiled with CFR 0.152.
 */
package maslab.test;

import java.io.FileWriter;
import java.util.ArrayList;
import maslab.orc.Gyro;
import maslab.orc.Orc;
import maslab.util.GetOpt;
import maslab.util.StringUtil;

public class GyroDriftTrials {
    public static void main(String[] args) {
        FileWriter outs;
        Orc orc;
        try {
            orc = new Orc();
        }
        catch (Exception ex) {
            return;
        }
        Gyro gyro = new Gyro(orc);
        GetOpt opts = new GetOpt();
        opts.parse(args);
        ArrayList<String> extraArgs = opts.getExtraArgs();
        int trials = 0;
        int seconds = 600;
        double[] data = new double[seconds];
        try {
            outs = new FileWriter(extraArgs.get(0));
        }
        catch (Exception ex) {
            System.out.println("Couldn't open output file.");
            return;
        }
        while (true) {
            int sec;
            System.out.println("************** trial " + trials + " **************************");
            System.out.print("  Calibrating...");
            System.out.flush();
            gyro.calibrate(5000);
            System.out.println("...done");
            System.out.print("  ");
            for (sec = 0; sec < seconds; ++sec) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                data[sec] = gyro.getRadians() * 180.0 / Math.PI;
                System.out.print(" " + StringUtil.formatDouble(data[sec], 5));
                System.out.flush();
            }
            System.out.println("");
            try {
                outs.write(StringUtil.formatDouble(2.5 + 7.629510948348211E-5 * gyro.gyroCorrectionPerTick, 5) + " ");
                for (sec = 0; sec < seconds; ++sec) {
                    outs.write(StringUtil.formatDouble(data[sec], 5) + " ");
                }
                outs.write("\n");
                outs.flush();
            }
            catch (Exception ex) {
                System.out.println("Error writing!");
            }
            ++trials;
        }
    }
}

