/*
 * Decompiled with CFR 0.152.
 */
package maslab.test;

import java.util.ArrayList;
import java.util.Arrays;
import maslab.orc.Orc;
import maslab.util.GetOpt;
import maslab.util.StringUtil;

public class AnalogTest {
    public static void main(String[] args) {
        Orc orc;
        try {
            orc = new Orc();
        }
        catch (Exception ex) {
            return;
        }
        GetOpt opts = new GetOpt();
        opts.parse(args);
        ArrayList<String> extraArgs = opts.getExtraArgs();
        orc.setCacheLifetime(-1);
        int SIZE = 100;
        while (true) {
            double[] data = new double[SIZE];
            double max = 0.0;
            double min = 5.0;
            for (int i = 0; i < SIZE; ++i) {
                double v;
                data[i] = v = orc.analogRead(8);
                max = Math.max(max, v);
                min = Math.min(min, v);
            }
            Arrays.sort(data);
            double offset = 0.059205;
            double maxcur = (max - offset) / 0.18;
            double mincur = (min - offset) / 0.18;
            double medcur = (data[SIZE >> 1] - offset) / 0.18;
            System.out.println("max: " + max + "\t min " + min + "\t cur ");
            System.out.println("maxcur: " + StringUtil.formatDouble(maxcur * 1000.0, 0));
            System.out.println("mincur: " + StringUtil.formatDouble(mincur * 1000.0, 0));
            System.out.println("medcur: " + StringUtil.formatDouble(medcur * 1000.0, 0));
        }
    }
}

