/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import maslab.telemetry.JugPacket;
import maslab.telemetry.MTQueue;
import maslab.util.ConsoleLoggerPublisher;
import maslab.util.Logger;

public class JugHub {
    protected Logger log = new Logger("JugHub");
    protected HashMap<String, Channel> channels = new HashMap();
    public static final int DEFAULTPORT = 7780;
    protected static int numInstances = 0;
    public static JugHub localJugHub = null;

    public JugHub() {
        this.channels.put("*", new Channel("*"));
        try {
            ListenerThread lt = new ListenerThread(7780);
            lt.start();
        }
        catch (Exception ex) {
            this.log.error("Unable to listen", ex);
        }
        this.log.verbose("Hub started.");
        if (++numInstances > 1) {
            this.log.warn("More than one JugHub instance created!");
        }
        localJugHub = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel getChannel(String cname) {
        HashMap<String, Channel> hashMap = this.channels;
        synchronized (hashMap) {
            Channel c = this.channels.get(cname);
            if (c == null) {
                c = new Channel(cname);
                this.channels.put(cname, c);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPackets(String cname, JugPacket p) {
        Channel c;
        Channel channel = c = this.getChannel(cname);
        synchronized (channel) {
            for (Connection conn : c.subscribers) {
                conn.out(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacketToPublishers(String cname, JugPacket p) {
        Channel c;
        Channel channel = c = this.getChannel(cname);
        synchronized (channel) {
            for (Connection conn : c.publishers) {
                conn.out(p);
            }
        }
    }

    public void directReceive(JugPacket p) {
        if (p.command != 3) {
            this.log.error("directReceive called with non message packet!");
            return;
        }
        p.command = 103;
        if (p.data == null) {
            this.log.warn("null message received on " + p.channelName);
        } else {
            this.sendPackets(p.channelName, p);
            this.log.vverbose("received message " + p.data.length);
        }
    }

    public static void main(String[] args) {
        ConsoleLoggerPublisher clp = new ConsoleLoggerPublisher();
        clp.setGlobalLevel(7);
        Logger.addPublisher(clp);
        new JugHub();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public class LocalConnection
    extends Connection {
        public LocalConnection() {
            this.init();
        }

        public void out(JugPacket p) {
        }
    }

    public abstract class Connection {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            Channel c;
            Channel channel = c = JugHub.this.getChannel("*");
            synchronized (channel) {
                c.subscribers.add(this);
            }
            this.doList();
        }

        public abstract void out(JugPacket var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void in(JugPacket p) throws IOException {
            switch (p.command) {
                case 0: {
                    DataInputStream dins = p.getDataInputStream();
                    int nonce = dins.readInt();
                    p = new JugPacket(100);
                    DataOutputStream douts = p.getDataOutputStream();
                    douts.writeInt(nonce);
                    this.out(p);
                    break;
                }
                case 1: {
                    Channel c = JugHub.this.getChannel(p.channelName);
                    if (c.publishers.size() == 0) {
                        p.command = 101;
                        JugHub.this.sendPackets("*", p);
                    }
                    Channel channel = c;
                    synchronized (channel) {
                        if (!c.publishers.contains(this)) {
                            c.publishers.add(this);
                        }
                    }
                    this.sendSubCountMessage(c, this);
                    break;
                }
                case 2: {
                    Channel c;
                    Channel channel = c = JugHub.this.getChannel(p.channelName);
                    synchronized (channel) {
                        if (c.publishers.contains(this)) {
                            c.publishers.remove(this);
                        }
                        if (c.publishers.size() == 0) {
                            p.command = 102;
                            JugHub.this.sendPackets("*", p);
                        }
                        break;
                    }
                }
                case 5: {
                    this.doList();
                    break;
                }
                case 3: {
                    p.command = 103;
                    if (p.data == null) {
                        JugHub.this.log.warn("null message received on " + p.channelName);
                        break;
                    }
                    JugHub.this.sendPackets(p.channelName, p);
                    JugHub.this.log.vverbose("received message " + p.data.length);
                    break;
                }
                case 6: {
                    Channel c;
                    Channel channel = c = JugHub.this.getChannel(p.channelName);
                    synchronized (channel) {
                        if (!c.subscribers.contains(this)) {
                            c.subscribers.add(this);
                        }
                    }
                    this.sendAllSubCountMessages(c);
                    break;
                }
                case 7: {
                    Channel c;
                    Channel channel = c = JugHub.this.getChannel(p.channelName);
                    synchronized (channel) {
                        c.subscribers.remove(this);
                    }
                    this.sendAllSubCountMessages(c);
                    break;
                }
                case 10: {
                    this.sendSubCountMessage(JugHub.this.getChannel(p.channelName), this);
                    break;
                }
            }
        }

        protected void sendSubCountMessage(Channel c, Connection conn) throws IOException {
            JugPacket p = new JugPacket(110, c.name);
            DataOutputStream douts = p.getDataOutputStream();
            douts.writeInt(c.subscribers.size());
            douts.flush();
            conn.out(p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendAllSubCountMessages(Channel c) throws IOException {
            Channel channel = c;
            synchronized (channel) {
                for (Connection conn : c.publishers) {
                    this.sendSubCountMessage(c, conn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doList() {
            JugHub.this.log.debug("doList");
            HashMap<String, Channel> hashMap = JugHub.this.channels;
            synchronized (hashMap) {
                for (String cname : JugHub.this.channels.keySet()) {
                    Channel c;
                    JugHub.this.log.debug("doList: " + cname);
                    if (cname.equals("*")) continue;
                    Channel channel = c = JugHub.this.getChannel(cname);
                    synchronized (channel) {
                        if (c.publishers.size() > 0) {
                            JugPacket p = new JugPacket(101, cname);
                            this.out(p);
                        }
                    }
                }
            }
        }
    }

    public class TCPConnection
    extends Connection {
        Socket sock;
        MTQueue<JugPacket> outqueue;
        WriterThread writer;
        ReaderThread reader;
        JugPacket EXIT = new JugPacket(0);
        long clockSkew = 0L;

        public TCPConnection(Socket sock) {
            this.sock = sock;
            this.outqueue = new MTQueue();
            try {
                this.writer = new WriterThread();
                this.writer.start();
                this.reader = new ReaderThread();
                this.reader.start();
                this.init();
            }
            catch (IOException ex) {
                JugHub.this.log.error("Unable to create writer/reader", ex);
            }
        }

        public void out(JugPacket p) {
            if (this.outqueue.size() > 10 && p.size() > 2048) {
                JugHub.this.log.warn("dropping packet of size " + p.size());
                return;
            }
            if (this.outqueue.size() > 1000) {
                JugHub.this.log.error("queue overflow. dropping packet.");
                return;
            }
            this.outqueue.put(p);
        }

        protected class ReaderThread
        extends Thread {
            DataInputStream ins;

            public ReaderThread() throws IOException {
                this.setDaemon(true);
                this.ins = new DataInputStream(new BufferedInputStream(TCPConnection.this.sock.getInputStream()));
            }

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            JugPacket p = new JugPacket(this.ins);
                            TCPConnection.this.in(p);
                        }
                    }
                    catch (IOException ex) {
                        TCPConnection.this.outqueue.put(TCPConnection.this.EXIT);
                        return;
                    }
                    catch (Exception ex) {
                        JugHub.this.log.warn("Unexpected exception", ex);
                        continue;
                    }
                    break;
                }
            }
        }

        protected class WriterThread
        extends Thread {
            DataOutputStream outs;

            public WriterThread() throws IOException {
                this.setDaemon(true);
                this.outs = new DataOutputStream(new BufferedOutputStream(TCPConnection.this.sock.getOutputStream()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JugPacket o;
                while ((o = TCPConnection.this.outqueue.getBlock()) != TCPConnection.this.EXIT) {
                    try {
                        if (o instanceof byte[]) {
                            this.outs.write((byte[])o);
                        } else if (o instanceof String) {
                            this.outs.writeBytes((String)((Object)o));
                        } else if (o instanceof JugPacket) {
                            o.write(this.outs);
                        } else {
                            JugHub.this.log.error("Unknown type " + o.getClass().getName());
                        }
                        JugHub.this.log.vverbose("sent message");
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
                try {
                    TCPConnection.this.sock.close();
                }
                catch (Exception ex) {
                    JugHub.this.log.error("Unable to close socket", ex);
                }
                HashMap<String, Channel> hashMap = JugHub.this.channels;
                synchronized (hashMap) {
                    Iterator<Channel> i = JugHub.this.channels.values().iterator();
                    while (i.hasNext()) {
                        Channel c;
                        Channel channel = c = i.next();
                        synchronized (channel) {
                            c.subscribers.remove(TCPConnection.this);
                            c.publishers.remove(TCPConnection.this);
                            if (c.publishers.size() == 0) {
                                JugPacket p = new JugPacket(102, c.name);
                                JugHub.this.sendPackets("*", p);
                            }
                            try {
                                TCPConnection.this.sendAllSubCountMessages(c);
                            }
                            catch (IOException ex) {
                                JugHub.this.log.warn("IOexception generating unsub");
                            }
                        }
                    }
                }
                JugHub.this.log.verbose("disconnected");
            }
        }
    }

    protected class ListenerThread
    extends Thread {
        ServerSocket serversock;

        public ListenerThread(int port) throws IOException {
            this.serversock = new ServerSocket(port);
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    Socket sock = this.serversock.accept();
                    new TCPConnection(sock);
                    JugHub.this.log.verbose("New incoming connection.");
                    continue;
                }
                catch (Exception ex) {
                    JugHub.this.log.error("Unable to accept", ex);
                    continue;
                }
                break;
            }
        }
    }

    protected class Channel {
        LinkedList<Connection> subscribers = new LinkedList();
        LinkedList<Connection> publishers = new LinkedList();
        String name;

        Channel(String name) {
            this.name = name;
        }
    }
}

