/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;

public class SmallButton
extends JComponent {
    public static final long serialVersionUID = 1001L;
    int textwidth = 20;
    int textheight = 10;
    int marginx = 2;
    int marginy = 1;
    String label;
    boolean pressed = false;
    ArrayList<ActionListener> actionListeners = new ArrayList();
    boolean firstdraw = true;

    public SmallButton(String label) {
        this.label = label;
        this.addMouseListener(new MyMouseListener());
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.textwidth + this.marginx * 2 + 10, this.textheight + this.marginy * 2 + 3);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public synchronized void paint(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int height = this.getHeight();
        int width = this.getWidth();
        g.translate(this.marginx, this.marginy);
        int cy = (height -= this.marginy * 2) / 2;
        int cx = (width -= this.marginx * 2) / 2;
        Color bgcolor = this.getParent().getBackground();
        g.setColor(bgcolor);
        g.fillRect(0, 0, width, height);
        RoundRectangle2D.Double barr = new RoundRectangle2D.Double(0.0, cy - height / 2, width, height, height, height);
        g.setColor(this.pressed ? Color.gray : Color.white);
        g.fill(barr);
        g.setColor(Color.black);
        g.draw(barr);
        Font f = new Font("Helvetica", 0, 9);
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        this.textwidth = fm.stringWidth(this.label);
        this.textheight = fm.getMaxAscent() + fm.getMaxDescent();
        g.drawString(this.label, cx - this.textwidth / 2, cy + fm.getMaxAscent() / 2);
        if (this.firstdraw) {
            this.firstdraw = false;
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
    }

    void handleClick() {
        ActionEvent ae = new ActionEvent(this, 1001, "CLICK");
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(ae);
        }
        this.repaint();
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            SmallButton.this.pressed = true;
            SmallButton.this.repaint();
            SmallButton.this.handleClick();
        }

        public void mouseReleased(MouseEvent e) {
            SmallButton.this.pressed = false;
            SmallButton.this.repaint();
        }
    }
}

