/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.JPanel;

public class SignalPlot
extends JPanel {
    public static final long serialVersionUID = 1001L;
    LinkedList<Sample> samples;
    int MAXIMUMHISTORY = 150;
    int VERTICALBARSPACING = 50;
    int LABELXMARGIN = 2;
    int LABELYMARGIN = 1;
    int nextseqno = 0;
    String label = "";
    Color labelbgcolor = new Color(0.2f, 0.2f, 0.2f, 0.7f);

    public SignalPlot() {
        this.samples = new LinkedList();
    }

    public void setLabel(String l) {
        this.label = l;
        this.repaint();
    }

    public synchronized void paint(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        int width = this.getWidth();
        if (width > this.MAXIMUMHISTORY) {
            this.MAXIMUMHISTORY = width;
        }
        int height = this.getHeight();
        g.setColor(Color.black);
        g.fillRect(0, 0, width, height);
        int x = width - 1;
        for (Sample s : this.samples) {
            if (s.seqno % this.VERTICALBARSPACING == 0) {
                g.setColor(Color.darkGray);
                g.drawLine(x, 0, x, height);
            }
            for (int i = 0; i < s.c.length; ++i) {
                float v = s.v[i];
                g.setColor(s.c[i]);
                int y = (int)((float)height - v * (float)height);
                if (y < 1) {
                    y = 1;
                }
                if (y >= height - 2) {
                    y = height - 2;
                }
                g.drawLine(x, y, x, y);
            }
            if (--x >= 0) continue;
            break;
        }
        Font f = new Font("Helvetica", 0, 10);
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        int labelheight = fm.getMaxAscent();
        int labely = 0;
        if (this.samples.size() == 0) {
            return;
        }
        Sample s = this.samples.getFirst();
        for (int i = 0; i < s.c.length; ++i) {
            if (s.l[i] == "") continue;
            int labelwidth = fm.stringWidth(s.l[i]);
            Rectangle2D.Float graybox = new Rectangle2D.Float(width - labelwidth - 2 * this.LABELXMARGIN, labely, labelwidth + 2 * this.LABELXMARGIN, labelheight + 2 * this.LABELYMARGIN);
            g.setColor(this.labelbgcolor);
            g.fill(graybox);
            g.setColor(s.c[i]);
            g.drawString(s.l[i], width - labelwidth - this.LABELXMARGIN, labely + labelheight + this.LABELYMARGIN);
            labely += labelheight + 1;
        }
    }

    public synchronized void addData(Object ... args) {
        Sample s = new Sample();
        s.c = new Color[args.length / 3];
        s.v = new float[args.length / 3];
        s.l = new String[args.length / 3];
        s.seqno = this.nextseqno++;
        if (this.nextseqno % this.VERTICALBARSPACING == 0) {
            this.nextseqno = 0;
        }
        for (int i = 0; i < args.length; i += 3) {
            s.c[i / 3] = (Color)args[i];
            s.v[i / 3] = args[i + 1] instanceof Float ? ((Float)args[i + 1]).floatValue() : (args[i + 1] instanceof Double ? new Float((Double)args[i + 1]).floatValue() : 0.0f);
            s.l[i / 3] = args[i + 2] != null ? (String)args[i + 2] : "";
        }
        this.samples.addFirst(s);
        this.repaint();
        if (this.samples.size() > this.MAXIMUMHISTORY) {
            this.samples.removeLast();
        }
    }

    class Sample {
        int seqno;
        Color[] c;
        float[] v;
        String[] l;

        Sample() {
        }
    }
}

