/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class PopupMenuButton
extends JPanel {
    int WIDTH = 10;
    int HEIGHT = 10;
    public static final long serialVersionUID = 1001L;
    boolean pressed = false;
    JPopupMenu menu;
    Color interiorColor;

    public PopupMenuButton(JPopupMenu menu, Color ic) {
        this.interiorColor = ic;
        this.menu = menu;
        this.addMouseListener(new MyMouseListener());
        menu.addPopupMenuListener(new MyMenuListener());
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.WIDTH, this.HEIGHT);
    }

    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.getParent().getBackground());
        g.fillRect(0, 0, width, height);
        Polygon p = new Polygon(new int[]{0, 0, width}, new int[]{0, height, height / 2}, 3);
        if (this.pressed) {
            g.setColor(this.interiorColor.darker());
        } else {
            g.setColor(this.interiorColor);
        }
        g.fillPolygon(p);
        g.setColor(Color.black);
        g.drawPolygon(p);
    }

    class MyMenuListener
    implements PopupMenuListener {
        MyMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            PopupMenuButton.this.pressed = false;
            PopupMenuButton.this.repaint();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            PopupMenuButton.this.pressed = false;
            PopupMenuButton.this.repaint();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            PopupMenuButton.this.pressed = true;
            PopupMenuButton.this.repaint();
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            PopupMenuButton.this.menu.show(PopupMenuButton.this, PopupMenuButton.this.getWidth(), 0);
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

