/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EnumSet;
import java.util.Formatter;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import maslab.orc.Orc;
import maslab.orc.OrcUpdateListener;
import maslab.orcspy.GoalSlider;
import maslab.orcspy.GoalSliderListener;
import maslab.orcspy.PopupMenuButton;
import maslab.orcspy.SignalPlot;
import maslab.orcspy.SmallButton;
import maslab.util.Logger;
import maslab.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinPanel
extends JPanel
implements OrcUpdateListener {
    public static final long serialVersionUID = 1001L;
    EnumSet<Orc.PinMode> modes;
    int port;
    JLabel namelabel;
    JComboBox modebox;
    JLabel modelabel;
    JPopupMenu modemenu;
    JComboBox digvalue;
    JLabel diglabel;
    GoalSlider servoslider;
    JComboBox servoprofile;
    GoalSlider pwmperiod;
    GoalSlider pwmdutycycle;
    GoalSlider dacslider;
    SmallButton usping;
    JPanel cardpanel;
    CardLayout cardlayout;
    JLabel analogfilterlabel;
    JPopupMenu analogfiltermenu;
    Color lightBlue = new Color(200, 200, 255);
    Color darkBlue = new Color(100, 100, 255);
    Color yellow = new Color(255, 255, 0);
    Formatter fmt = new Formatter();
    SignalPlot plot = new SignalPlot();
    SmallButton digouttoggle;
    static Logger log = new Logger("Pin");
    static final int INDENT_PX = 20;
    Orc orc;
    int uspingcount = 0;
    boolean minimized = false;

    public PinPanel(Orc orc, int port, EnumSet<Orc.PinMode> modes) {
        super(new GridBagLayout());
        this.orc = orc;
        this.port = port;
        this.modes = modes;
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagConstraints pgbc = new GridBagConstraints();
        pgbc.weightx = 0.0;
        pgbc.weighty = 0.0;
        pgbc.anchor = 10;
        pgbc.fill = 1;
        Font smallfont = new Font("Dialog", 0, 9);
        JPanel namerow = new JPanel(new GridBagLayout());
        namerow.setBackground(this.darkBlue);
        this.namelabel = new JLabel(" " + port);
        this.namelabel.setForeground(this.yellow);
        this.namelabel.setFont(smallfont);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        namerow.add((Component)this.namelabel, gbc);
        this.modelabel = new JLabel("");
        this.modelabel.setFont(smallfont);
        this.modemenu = new JPopupMenu();
        PinModeItemActionListener pmial = new PinModeItemActionListener();
        for (Orc.PinMode cap : modes) {
            PinModeItem pmi = new PinModeItem(cap);
            pmi.addActionListener(pmial);
            this.modemenu.add(pmi);
        }
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        namerow.add((Component)this.modelabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        namerow.add((Component)new PopupMenuButton(this.modemenu, this.lightBlue), gbc);
        pgbc.gridx = 0;
        pgbc.gridy = 0;
        this.add((Component)namerow, pgbc);
        JPanel digoutrow = new JPanel(new FlowLayout(2, 0, 0));
        this.digouttoggle = new SmallButton("toggle");
        this.digouttoggle.addActionListener(new DigOutToggleListener());
        digoutrow.add(this.digouttoggle);
        digoutrow.setBackground(this.lightBlue);
        JPanel uspingrow = new JPanel(new FlowLayout(2, 0, 0));
        this.usping = new SmallButton("ping");
        this.usping.addActionListener(new USPingActionListener());
        uspingrow.add(this.usping);
        uspingrow.setBackground(this.lightBlue);
        JPanel analogrow = new JPanel(new FlowLayout(2, 0, 0));
        this.analogfilterlabel = new JLabel("LPF: 0");
        this.analogfilterlabel.setFont(smallfont);
        this.analogfiltermenu = new JPopupMenu();
        AnalogFilterActionListener afal = new AnalogFilterActionListener();
        for (int i = 0; i < 16; ++i) {
            AnalogFilterItem afi = new AnalogFilterItem(i);
            this.analogfiltermenu.add(afi);
            afi.addActionListener(afal);
        }
        analogrow.add(this.analogfilterlabel);
        analogrow.add(new PopupMenuButton(this.analogfiltermenu, Color.white));
        analogrow.setBackground(this.lightBlue);
        JPanel dacrow = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        dacrow.add(Box.createHorizontalStrut(20), gbc);
        this.dacslider = new GoalSlider(0, 255, true);
        this.dacslider.addGoalSliderListener(new DACSliderListener());
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 9999.0;
        gbc.anchor = 17;
        dacrow.add((Component)this.dacslider, gbc);
        dacrow.setBackground(this.lightBlue);
        JPanel pwmrow = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        pwmrow.add(Box.createHorizontalStrut(20), gbc);
        this.pwmperiod = new GoalSlider(0, 255, true);
        this.pwmperiod.addGoalSliderListener(new PWMSliderListener());
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 9999.0;
        gbc.anchor = 17;
        pwmrow.add((Component)this.pwmperiod, gbc);
        this.pwmdutycycle = new GoalSlider(0, 255, true);
        this.pwmdutycycle.addGoalSliderListener(new PWMSliderListener());
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridy = -1;
        gbc.fill = 2;
        gbc.weightx = 9999.0;
        gbc.anchor = 17;
        pwmrow.add((Component)this.pwmdutycycle, gbc);
        pwmrow.setBackground(this.lightBlue);
        JPanel servorow = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        servorow.add(Box.createHorizontalStrut(20), gbc);
        this.servoslider = new GoalSlider(0, 65535, true);
        this.servoslider.addGoalSliderListener(new ServoGoalSliderListener());
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 9999.0;
        gbc.anchor = 17;
        servorow.add((Component)this.servoslider, gbc);
        servorow.setBackground(this.lightBlue);
        this.cardlayout = new CardLayout();
        this.cardpanel = new JPanel(this.cardlayout);
        this.cardpanel.add((Component)uspingrow, Orc.PinMode.SONAR_PING.toString());
        this.cardpanel.add((Component)servorow, Orc.PinMode.SERVO.toString());
        this.cardpanel.add((Component)digoutrow, Orc.PinMode.DIGITAL_OUT.toString());
        this.cardpanel.add((Component)analogrow, Orc.PinMode.ANALOG_IN.toString());
        this.cardpanel.add((Component)dacrow, Orc.PinMode.ANALOG_OUT.toString());
        this.cardpanel.add((Component)pwmrow, Orc.PinMode.PWM.toString());
        pgbc.gridx = 0;
        pgbc.gridy = 1;
        this.add((Component)this.cardpanel, pgbc);
        this.plot.setSize(new Dimension(200, 15));
        this.plot.setMinimumSize(new Dimension(100, 15));
        this.plot.setPreferredSize(new Dimension(200, 15));
        JPanel pcrow = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weighty = 99999.0;
        gbc.weightx = 99999.0;
        pcrow.add(Box.createHorizontalStrut(20));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        pcrow.add((Component)this.plot, gbc);
        pcrow.setBackground(this.lightBlue);
        gbc.insets = new Insets(0, 0, 0, 0);
        pgbc.gridx = 0;
        pgbc.gridy = 2;
        pgbc.weightx = 9999.0;
        pgbc.weighty = 999.0;
        this.add((Component)pcrow, pgbc);
        this.cardpanel.setVisible(false);
        this.updateCards();
        this.addMouseListener(new MyMouseListener());
        orc.addUpdateListener(this);
    }

    public void addMode(Orc.PinMode m) {
        this.modes.add(m);
    }

    @Override
    public void orcUpdated(Orc orc) {
        Orc.PinMode c = orc.pinModeRead(this.port);
        this.modelabel.setText(c.toString());
        this.updateCards();
        switch (c) {
            case ANALOG_IN: {
                float f = (float)orc.analogRead(this.port);
                this.plot.addData(Color.yellow, Float.valueOf(f / 5.0f), StringUtil.formatDouble(f, 4) + " V");
                this.analogfilterlabel.setText("LPF: " + orc.analogLPFRead(this.port));
                break;
            }
            case SONAR_PING: {
                int i = orc.ultrasoundPingCount(this.port);
                this.plot.addData(Color.white, Float.valueOf(i != this.uspingcount ? 1.0f : 0.0f), "");
                this.uspingcount = i;
                break;
            }
            case DIGITAL_OUT: 
            case DIGITAL_IN: 
            case DIGITAL_IN_PULLUP: 
            case DIGITAL_IN_PULLDOWN: {
                boolean b = orc.digitalRead(this.port);
                this.plot.addData(Color.white, Float.valueOf(b ? 1.0f : 0.0f), b ? "1" : "0");
                break;
            }
            case SONAR_ECHO: {
                double d = orc.ultrasoundRange(this.port);
                this.plot.addData(this.lightBlue, Float.valueOf((float)(d / 500.0)), StringUtil.formatDouble(d, 1) + " cm");
                break;
            }
            case SERVO: {
                int i = orc.servoRead(this.port);
                float f = (float)i / 65535.0f;
                this.servoslider.setActualValue(i);
                if (this.port < 2) {
                    float f2 = (float)orc.servoCurrentRead(this.port);
                    this.plot.addData(Color.yellow, Float.valueOf(f), "" + i, Color.red, Float.valueOf(f2), "" + (int)((double)f2 * 1000.0) + " mA");
                    break;
                }
                this.plot.addData(Color.yellow, Float.valueOf(f), "" + i);
                break;
            }
            case QUADPHASEFAST: 
            case QUADPHASE: 
            case MONOPHASE: {
                int i = orc.quadphaseRead(this.port);
                float f = (float)i / 65535.0f;
                int i2 = orc.quadphaseErrorsRead(this.port);
                float f2 = (float)(i2 % 16) / 16.0f;
                this.plot.addData(Color.yellow, Float.valueOf(f), "" + i, this.lightBlue, Float.valueOf(f2), "" + i2);
                break;
            }
            case ANALOG_OUT: {
                int i = orc.dacRead(this.port);
                this.dacslider.setActualValue(i);
                float f = (float)i / 255.0f;
                this.plot.addData(Color.yellow, Float.valueOf(f), "" + i);
                break;
            }
            case PWM: {
                this.pwmperiod.setActualValue(orc.pwmPeriodRead(this.port));
                this.pwmdutycycle.setActualValue(orc.pwmDutyCycleRead(this.port));
                int i = orc.pwmPeriodRead(this.port);
                float f = (float)i / 255.0f;
                int i2 = orc.pwmDutyCycleRead(this.port);
                float f2 = (float)i2 / 255.0f;
                this.plot.addData(Color.yellow, Float.valueOf(f), "" + i, this.lightBlue, Float.valueOf(f2), "" + i2);
            }
        }
    }

    void updateCards() {
        Orc.PinMode c = this.orc.pinModeRead(this.port);
        if (c == Orc.PinMode.SERVO || c == Orc.PinMode.DIGITAL_OUT || c == Orc.PinMode.SONAR_PING || c == Orc.PinMode.ANALOG_IN || c == Orc.PinMode.ANALOG_OUT || c == Orc.PinMode.PWM) {
            this.cardlayout.show(this.cardpanel, c.toString());
            this.cardpanel.setVisible(true);
        } else {
            this.cardpanel.setVisible(false);
        }
    }

    public class MyMouseListener
    implements MouseListener {
        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                PinPanel.this.minimized = !PinPanel.this.minimized;
                PinPanel.this.cardpanel.setVisible(!PinPanel.this.minimized);
                PinPanel.this.plot.setVisible(!PinPanel.this.minimized);
            }
        }
    }

    public class ServoProfileItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            ServoProfile sp = (ServoProfile)((Object)PinPanel.this.servoprofile.getSelectedItem());
            if (sp == ServoProfile.RAW) {
                PinPanel.this.servoslider.setMinimum(0);
                PinPanel.this.servoslider.setMaximum(65535);
            } else if (sp == ServoProfile.HITEC300) {
                PinPanel.this.servoslider.setMinimum(20000);
                PinPanel.this.servoslider.setMaximum(30000);
            } else if (sp == ServoProfile.FUTABA100) {
                PinPanel.this.servoslider.setMinimum(15000);
                PinPanel.this.servoslider.setMaximum(20000);
            }
        }
    }

    public class ServoGoalSliderListener
    implements GoalSliderListener {
        public void goalValueChanged(GoalSlider gs, int goalvalue) {
            PinPanel.this.orc.servoWrite(PinPanel.this.port, goalvalue);
        }
    }

    public class DACSliderListener
    implements GoalSliderListener {
        public void goalValueChanged(GoalSlider gs, int goalvalue) {
            PinPanel.this.orc.dacWrite(PinPanel.this.port, goalvalue);
        }
    }

    public class PWMSliderListener
    implements GoalSliderListener {
        public void goalValueChanged(GoalSlider gs, int goalvalue) {
            PinPanel.this.orc.pwmWrite(PinPanel.this.port, 0, PinPanel.this.pwmperiod.getGoalValue(), PinPanel.this.pwmdutycycle.getGoalValue());
        }
    }

    public class DigOutToggleListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PinPanel.this.orc.digitalWrite(PinPanel.this.port, !PinPanel.this.orc.digitalRead(PinPanel.this.port));
        }
    }

    public class DigitalItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            PinPanel.this.updateCards();
        }
    }

    public class USPingActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PinPanel.this.orc.ultrasoundPing(PinPanel.this.port);
        }
    }

    public class PinModeItemActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PinModeItem pmi = (PinModeItem)e.getSource();
            PinPanel.this.orc.pinModeWrite(PinPanel.this.port, pmi.mode);
            PinPanel.this.updateCards();
        }
    }

    public class AnalogFilterActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AnalogFilterItem afi = (AnalogFilterItem)e.getSource();
            PinPanel.this.orc.analogLPFWrite(PinPanel.this.port, afi.filterMode);
        }
    }

    class AnalogFilterItem
    extends JMenuItem {
        public static final long serialVersionUID = 1001L;
        public int filterMode;

        public AnalogFilterItem(int m) {
            super("" + m);
            this.filterMode = m;
        }
    }

    class PinModeItem
    extends JMenuItem {
        public static final long serialVersionUID = 1001L;
        public Orc.PinMode mode;

        public PinModeItem(Orc.PinMode m) {
            super(m.toString());
            this.mode = m;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServoProfile {
        RAW,
        HITEC300,
        FUTABA100;

    }
}

