/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.Color;
import java.awt.Graphics;
import java.util.LinkedList;
import javax.swing.JPanel;

public class PinCanvas
extends JPanel {
    public static final long serialVersionUID = 1001L;
    LinkedList<Sample> samples = new LinkedList();
    int MAXIMUMHISTORY = 300;
    int VERTICALBARSPACING = 50;
    int nextseqno = 0;

    public synchronized void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.black);
        g.fillRect(0, 0, width, height);
        int x = width - 1;
        for (Sample s : this.samples) {
            if (s.seqno % this.VERTICALBARSPACING == 0) {
                g.setColor(Color.darkGray);
                g.drawLine(x, 0, x, height);
            }
            for (int i = 0; i < s.c.length; ++i) {
                float v = s.v[i];
                g.setColor(s.c[i]);
                int y = (int)((float)height - v * (float)height);
                if (y < 0) {
                    y = 0;
                }
                if (y >= height) {
                    y = height - 1;
                }
                g.drawLine(x, y, x, y);
            }
            if (--x >= 0) continue;
            break;
        }
    }

    public synchronized void addData(Object ... args) {
        Sample s = new Sample();
        s.c = new Color[args.length / 2];
        s.v = new float[args.length / 2];
        s.seqno = this.nextseqno++;
        if (this.nextseqno % this.VERTICALBARSPACING == 0) {
            this.nextseqno = 0;
        }
        for (int i = 0; i < args.length; i += 2) {
            s.c[i] = (Color)args[i];
            s.v[i] = ((Float)args[i + 1]).floatValue();
        }
        this.samples.addFirst(s);
        this.repaint();
        if (this.samples.size() > this.MAXIMUMHISTORY) {
            this.samples.removeLast();
        }
    }

    class Sample {
        Color[] c;
        float[] v;
        int seqno;

        Sample() {
        }
    }
}

