/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import maslab.orc.Orc;
import maslab.orc.OrcUpdateListener;
import maslab.orcspy.JImage;
import maslab.orcspy.SmallButton;

public class PadPanel
extends JPanel
implements OrcUpdateListener {
    public static final long serialVersionUID = 1001L;
    Orc orc;
    int port;
    JLabel stoplabel = new JLabel("0");
    JLabel menulabel = new JLabel("0");
    JLabel sticklabel = new JLabel("0");
    JoystickCircle jc = new JoystickCircle();
    JImage lcdimage = new JImage(128, 64);
    SmallButton lcdimageupdate = new SmallButton("refresh");
    Color yellow = new Color(200, 200, 0);

    public PadPanel(Orc orc) {
        super(new GridBagLayout());
        Font smallfont = new Font("Dialog", 0, 9);
        this.orc = orc;
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagConstraints pgbc = new GridBagConstraints();
        pgbc.weightx = 1.0;
        pgbc.weighty = 1.0;
        pgbc.fill = 1;
        pgbc.anchor = 10;
        pgbc.gridx = 2;
        pgbc.gridy = 0;
        this.add((Component)new JLabel("Stick: "), pgbc);
        pgbc.gridx = 3;
        this.add((Component)this.sticklabel, pgbc);
        pgbc.gridx = 2;
        pgbc.gridy = 1;
        this.add((Component)new JLabel("Menu: "), pgbc);
        pgbc.gridx = 3;
        this.add((Component)this.menulabel, pgbc);
        pgbc.gridx = 2;
        pgbc.gridy = 2;
        this.add((Component)new JLabel("Stop: "), pgbc);
        pgbc.gridx = 3;
        this.add((Component)this.stoplabel, pgbc);
        pgbc.gridx = 1;
        pgbc.gridy = 0;
        pgbc.gridwidth = 1;
        pgbc.gridheight = 2;
        pgbc.weightx = 99.0;
        pgbc.weighty = 99.0;
        pgbc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jc, pgbc);
        pgbc.insets = new Insets(0, 0, 0, 0);
        pgbc.gridy = 2;
        this.add((Component)new JLabel(""), pgbc);
        pgbc.gridx = 0;
        pgbc.gridy = 0;
        pgbc.gridwidth = 1;
        pgbc.gridheight = 2;
        pgbc.weightx = 1.0;
        pgbc.weighty = 1.0;
        pgbc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lcdimage, pgbc);
        pgbc.insets = new Insets(0, 0, 0, 0);
        pgbc.gridx = 0;
        pgbc.gridy = 2;
        pgbc.gridwidth = 1;
        pgbc.gridheight = 1;
        pgbc.weightx = 1.0;
        pgbc.weighty = 1.0;
        pgbc.fill = 0;
        pgbc.anchor = 12;
        this.add((Component)this.lcdimageupdate, pgbc);
        this.lcdimageupdate.addActionListener(new ImageUpdateActionListener());
        this.setBackground(this.yellow);
        orc.addUpdateListener(this);
        this.lcdimage.setImage(orc.lcdRead());
        LCDUpdateThread lut = new LCDUpdateThread();
        lut.start();
    }

    public void orcUpdated(Orc orc) {
        int b = orc.padButtonsPoll();
        this.sticklabel.setText((b & 1) > 0 ? "1" : "0");
        this.menulabel.setText((b & 2) > 0 ? "1" : "0");
        this.stoplabel.setText((b & 4) > 0 ? "1" : "0");
        this.jc.repaint();
    }

    class LCDUpdateThread
    extends Thread {
        LCDUpdateThread() {
            this.setDaemon(true);
        }

        public void run() {
        }
    }

    public class ImageUpdateActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PadPanel.this.lcdimage.setImage(PadPanel.this.orc.lcdRead());
        }
    }

    class JoystickCircle
    extends JComponent {
        public static final long serialVersionUID = 1001L;

        JoystickCircle() {
        }

        public void paint(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            int cx = width / 2;
            int cy = height / 2;
            int diam = width < height ? width : height;
            int joyx = -diam / 2 * (PadPanel.this.orc.joyX() - 128) / 128;
            int joyy = -diam / 2 * (PadPanel.this.orc.joyY() - 128) / 128;
            g.setColor(Color.black);
            g.fillOval(cx - diam / 2, cy - diam / 2, diam, diam);
            g.setColor(Color.white);
            int knobsize = 6;
            g.fillOval(cx - joyx - knobsize / 2, cy - joyy - knobsize / 2, knobsize, knobsize);
        }

        public Dimension getMaximumSize() {
            return new Dimension(100, 100);
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, 60);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }
}

