/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import maslab.orc.Orc;
import maslab.orcspy.GyroPanel;
import maslab.orcspy.MotorPanel;
import maslab.orcspy.PadPanel;
import maslab.orcspy.PinPanel;
import maslab.orcspy.SmallButton;
import maslab.util.GetOpt;
import maslab.util.JLoggerPublisher;
import maslab.util.Logger;

public class OrcSpy {
    GetOpt opts = new GetOpt();
    Logger log = new Logger(this);
    JFrame frame;
    JLoggerPublisher jloggerPublisher;
    Canvas canv;
    PinPanel[] pins;
    MotorPanel[] motors;
    PadPanel padpanel;
    GyroPanel gyropanel;
    Box port0box;
    Box port1box;
    Box port2box;
    Orc orc;
    SmallButton allStopButton = new SmallButton("All Stop");

    public void doHelp() {
        if (this.opts.getReason() != null) {
            System.out.println("Invocation error: " + this.opts.getReason());
        }
        System.out.println("\nUsage: " + this.getClass().getName() + " [options]\n");
        this.opts.doHelp();
        System.out.println("\n");
    }

    public static void main(String[] args) {
        boolean forcequit = true;
        GetOpt opt = new GetOpt();
        opt.addBoolean('h', "help", false, "See this help");
        if (!opt.parse(args) || opt.getBoolean("help")) {
            opt.doHelp();
            return;
        }
        ArrayList<String> extraArgs = opt.getExtraArgs();
        try {
            Orc orc = extraArgs.size() == 0 ? new Orc() : new Orc(extraArgs.get(0));
            OrcSpy app = new OrcSpy(orc);
            forcequit = app.run(args);
        }
        catch (Exception ex) {
            Logger l = new Logger("OrcSpy Startup");
            l.error("Uncaught exception ", ex);
        }
        if (forcequit) {
            System.exit(0);
        }
    }

    public OrcSpy(Orc orc) {
        int i;
        int i2;
        this.orc = orc;
        this.frame = new JFrame(this.getClass().getName());
        this.frame.setSize(1000, 700);
        this.jloggerPublisher = new JLoggerPublisher();
        this.jloggerPublisher.setPreferredSize(new Dimension(100, 70));
        this.jloggerPublisher.getPublisher().setGlobalLevel(4);
        Container me = this.frame.getContentPane();
        this.pins = new PinPanel[20];
        ArrayList<EnumSet<Orc.PinMode>> modesets = new ArrayList<EnumSet<Orc.PinMode>>();
        for (i2 = 0; i2 < 20; ++i2) {
            modesets.add(i2, EnumSet.of(Orc.PinMode.DIGITAL_IN));
            ((EnumSet)modesets.get(i2)).add(Orc.PinMode.DIGITAL_IN);
            ((EnumSet)modesets.get(i2)).add(Orc.PinMode.DIGITAL_IN_PULLUP);
            ((EnumSet)modesets.get(i2)).add(Orc.PinMode.DIGITAL_IN_PULLDOWN);
            ((EnumSet)modesets.get(i2)).add(Orc.PinMode.DIGITAL_OUT);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            ((EnumSet)modesets.get(i2)).add(Orc.PinMode.SERVO);
        }
        for (i2 = 8; i2 < 16; ++i2) {
            ((EnumSet)modesets.get(i2)).add(Orc.PinMode.ANALOG_IN);
        }
        ((EnumSet)modesets.get(0)).add(Orc.PinMode.ANALOG_IN);
        ((EnumSet)modesets.get(3)).add(Orc.PinMode.ANALOG_IN);
        ((EnumSet)modesets.get(16)).add(Orc.PinMode.ANALOG_IN);
        ((EnumSet)modesets.get(19)).add(Orc.PinMode.ANALOG_IN);
        ((EnumSet)modesets.get(4)).add(Orc.PinMode.SONAR_PING);
        ((EnumSet)modesets.get(5)).add(Orc.PinMode.SONAR_ECHO);
        ((EnumSet)modesets.get(6)).add(Orc.PinMode.SONAR_PING);
        ((EnumSet)modesets.get(7)).add(Orc.PinMode.SONAR_ECHO);
        ((EnumSet)modesets.get(12)).add(Orc.PinMode.ANALOG_OUT);
        ((EnumSet)modesets.get(14)).add(Orc.PinMode.PWM);
        for (i2 = 16; i2 < 20; ++i2) {
            ((EnumSet)modesets.get(i2)).add(Orc.PinMode.QUADPHASE);
            ((EnumSet)modesets.get(i2)).add(Orc.PinMode.QUADPHASEFAST);
        }
        ((EnumSet)modesets.get(16)).add(Orc.PinMode.MONOPHASE);
        ((EnumSet)modesets.get(18)).add(Orc.PinMode.MONOPHASE);
        for (i2 = 0; i2 < 20; ++i2) {
            this.pins[i2] = new PinPanel(orc, i2, (EnumSet)modesets.get(i2));
        }
        JPanel ports = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        for (i = 0; i < 20; ++i) {
            gbc.gridx = 0 + i / 4;
            gbc.gridy = i % 4;
            ports.add((Component)this.pins[i], gbc);
        }
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.motors = new MotorPanel[4];
        for (i = 0; i < 4; ++i) {
            this.motors[i] = new MotorPanel(orc, i);
            gbc.gridx = 5;
            gbc.gridy = i;
            ports.add((Component)this.motors[i], gbc);
        }
        this.padpanel = new PadPanel(orc);
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = 4;
        gbc.gridheight = 1;
        ports.add((Component)this.padpanel, gbc);
        this.gyropanel = new GyroPanel(orc);
        gbc.gridx = 3;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.gridheight = 1;
        ports.add((Component)this.gyropanel, gbc);
        gbc.gridx = 5;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        ports.add((Component)this.allStopButton, gbc);
        this.allStopButton.addActionListener(new AllStopActionListener());
        JSplitPane jsp = new JSplitPane(0, ports, this.jloggerPublisher);
        jsp.setDividerLocation(0.9);
        jsp.setResizeWeight(0.9);
        me.add((Component)jsp, "Center");
        this.frame.addWindowListener(new MyWindowListener());
    }

    public boolean run(String[] args) throws Exception {
        this.opts.addBoolean('h', "help", false, "Show this help");
        if (!this.opts.parse(args) || this.opts.getBoolean("help")) {
            System.out.println("Usage: java -jar maslab.jar <IPAddress>\n");
            this.doHelp();
            return true;
        }
        this.frame.setVisible(true);
        this.frame.setMinimumSize(new Dimension(400, 300));
        this.log.output("Started...");
        return false;
    }

    public class AllStopActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            OrcSpy.this.orc.allStop();
        }
    }

    class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

