/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import maslab.orc.Orc;
import maslab.orc.OrcUpdateListener;
import maslab.orcspy.GoalSlider;
import maslab.orcspy.GoalSliderListener;
import maslab.orcspy.SignalPlot;

public class MotorPanel
extends JPanel
implements OrcUpdateListener {
    public static final long serialVersionUID = 1001L;
    Orc orc;
    int port;
    Color lightBlue = new Color(200, 200, 255);
    Color lightRed = new Color(255, 100, 100);
    Color darkRed = new Color(100, 0, 0);
    Color yellow = new Color(255, 255, 0);
    JLabel namelabel;
    SignalPlot pwmplot = new SignalPlot();
    SignalPlot currentplot = new SignalPlot();
    static final int INDENT_PX = 20;
    GoalSlider pwmslider;
    GoalSlider slewslider;

    public MotorPanel(Orc orc, int port) {
        super(new GridBagLayout());
        this.orc = orc;
        this.port = port;
        Font smallfont = new Font("Dialog", 0, 9);
        this.setBackground(this.lightRed);
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagConstraints pgbc = new GridBagConstraints();
        pgbc.gridx = 0;
        pgbc.gridy = 0;
        pgbc.gridwidth = 2;
        pgbc.weightx = 1.0;
        pgbc.weighty = 1.0;
        pgbc.fill = 1;
        JPanel nameholder = new JPanel(new FlowLayout(0));
        this.namelabel = new JLabel(" Motor " + port);
        nameholder.add(this.namelabel);
        this.namelabel.setForeground(this.yellow);
        nameholder.setBackground(this.darkRed);
        this.namelabel.setFont(smallfont);
        this.add((Component)nameholder, pgbc);
        pgbc.gridx = 0;
        pgbc.gridy = 1;
        pgbc.gridwidth = 1;
        pgbc.weightx = 1.0;
        pgbc.weighty = 1.0;
        pgbc.fill = 1;
        this.add(Box.createHorizontalStrut(20), pgbc);
        this.pwmslider = new GoalSlider(-255, 255, true);
        pgbc.weightx = 999.0;
        pgbc.weighty = 1.0;
        pgbc.gridx = 1;
        pgbc.gridy = 1;
        pgbc.fill = 1;
        this.add((Component)this.pwmslider, pgbc);
        this.pwmplot.setSize(new Dimension(200, 15));
        this.pwmplot.setMinimumSize(new Dimension(100, 15));
        this.pwmplot.setPreferredSize(new Dimension(200, 15));
        pgbc.weightx = 999.0;
        pgbc.weighty = 999.0;
        pgbc.gridx = 1;
        pgbc.gridy = 2;
        pgbc.fill = 1;
        this.add((Component)this.pwmplot, pgbc);
        this.slewslider = new GoalSlider(1, 255, true);
        this.slewslider.addGoalSliderListener(new SlewGoalSliderListener());
        pgbc.weightx = 1.0;
        pgbc.weighty = 1.0;
        pgbc.gridx = 1;
        pgbc.gridy = 3;
        pgbc.fill = 1;
        this.add((Component)this.slewslider, pgbc);
        pgbc.weightx = 1.0;
        pgbc.weighty = 1.0;
        pgbc.gridx = 1;
        pgbc.gridy = 5;
        pgbc.fill = 1;
        this.add(Box.createVerticalStrut(2), pgbc);
        this.pwmslider.addGoalSliderListener(new PWMGoalSliderListener());
        orc.addUpdateListener(this);
    }

    public void orcUpdated(Orc orc) {
        this.pwmplot.addData(Color.darkGray, Float.valueOf(0.5f), "", Color.white, Float.valueOf(0.5f + (float)orc.motorActualRead(this.port) / 512.0f), "" + orc.motorActualRead(this.port), Color.green, Float.valueOf(0.5f + (float)orc.motorGoalRead(this.port) / 512.0f), "" + orc.motorGoalRead(this.port), Color.red, Float.valueOf((float)orc.motorCurrentRead(this.port) / 2.0f), "" + (int)(orc.motorCurrentRead(this.port) * 1000.0) + " mA");
        this.pwmslider.setActualValue(orc.motorActualRead(this.port));
        this.slewslider.setActualValue(orc.motorSlewRead(this.port));
        this.currentplot.addData(Color.yellow, Float.valueOf((float)orc.motorCurrentRead(this.port) / 2.0f), "" + (int)(orc.motorCurrentRead(this.port) * 1000.0) + " mA");
    }

    public class SlewGoalSliderListener
    implements GoalSliderListener {
        public void goalValueChanged(GoalSlider gs, int goalvalue) {
            MotorPanel.this.orc.motorSlewWrite(MotorPanel.this.port, goalvalue);
        }
    }

    class PWMGoalSliderListener
    implements GoalSliderListener {
        PWMGoalSliderListener() {
        }

        public void goalValueChanged(GoalSlider gs, int v) {
            MotorPanel.this.orc.motorWrite(MotorPanel.this.port, v);
        }
    }
}

