/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import maslab.orc.Gyro;
import maslab.orc.Orc;
import maslab.orc.OrcUpdateListener;
import maslab.orcspy.SignalPlot;
import maslab.orcspy.SmallButton;
import maslab.util.GetOpt;
import maslab.util.StringUtil;

public class GyroPanel
extends JPanel
implements OrcUpdateListener {
    public static final long serialVersionUID = 1001L;
    Orc orc;
    SmallButton calibratebutton = new SmallButton("Calibrate");
    SignalPlot plot = new SignalPlot();
    SignalPlot detailplot = new SignalPlot();
    Color lightBlue = new Color(200, 200, 255);
    Color lightRed = new Color(255, 100, 100);
    Color darkRed = new Color(100, 0, 0);
    Color yellow = new Color(255, 255, 0);
    static final int INDENT_PX = 20;
    CompassWidget cw = new CompassWidget();
    Gyro gyro;

    public GyroPanel(Orc orc) {
        super(new GridBagLayout());
        this.orc = orc;
        this.gyro = new Gyro(orc);
        Font smallfont = new Font("Dialog", 0, 9);
        this.setBackground(this.lightRed);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JPanel nameholder = new JPanel(new FlowLayout(0));
        JLabel namelabel = new JLabel(" Gyro ");
        nameholder.add(namelabel);
        namelabel.setForeground(this.yellow);
        nameholder.setBackground(this.darkRed);
        namelabel.setFont(smallfont);
        this.add((Component)nameholder, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add(Box.createHorizontalStrut(20), gbc);
        this.detailplot.setSize(new Dimension(200, 15));
        this.detailplot.setMinimumSize(new Dimension(100, 15));
        this.detailplot.setPreferredSize(new Dimension(200, 15));
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.weightx = 999.0;
        gbc.weighty = 999.0;
        gbc.fill = 1;
        this.add((Component)this.detailplot, gbc);
        this.plot.setSize(new Dimension(200, 15));
        this.plot.setMinimumSize(new Dimension(100, 15));
        this.plot.setPreferredSize(new Dimension(200, 15));
        gbc.insets = new Insets(1, 4, 1, 1);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.weightx = 999.0;
        gbc.weighty = 999.0;
        gbc.fill = 1;
        this.add((Component)this.plot, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 2, 0, 2);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add((Component)this.cw, gbc);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.add((Component)this.calibratebutton, gbc);
        this.calibratebutton.addActionListener(new CalibrateActionListener());
        orc.addUpdateListener(this);
    }

    public void orcUpdated(Orc orc) {
        double theta = this.gyro.getRadians();
        double volts = orc.analogRead(15);
        this.plot.addData(Color.yellow, (theta + Math.PI) / (Math.PI * 2), StringUtil.formatDouble(180.0 * theta / Math.PI, 2));
        this.detailplot.addData(Color.blue, 0.5, null, Color.yellow, 0.5 + 60.0 * (volts - this.gyro.lastnull), StringUtil.formatDouble(volts, 4));
        this.cw.setTheta(theta);
    }

    public static void main(String[] args) {
        Orc orc;
        try {
            orc = new Orc();
        }
        catch (Exception ex) {
            return;
        }
        GetOpt opts = new GetOpt();
        JFrame frame = new JFrame("GyroPanel");
        frame.getContentPane().setLayout(new BorderLayout());
        GyroPanel gyropanel = new GyroPanel(orc);
        frame.add((Component)gyropanel, "Center");
        frame.setVisible(true);
        frame.setSize(600, 300);
    }

    class CompassWidget
    extends JComponent {
        public static final long serialVersionUID = 1001L;
        double theta;

        CompassWidget() {
        }

        public void setTheta(double theta) {
            this.theta = theta;
            this.repaint();
        }

        public Dimension getMaximumSize() {
            return new Dimension(100, 100);
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, 60);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public synchronized void paint(Graphics gin) {
            int headlength;
            Graphics2D g = (Graphics2D)gin;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getWidth();
            int height = this.getHeight();
            int cx = width / 2;
            int cy = height / 2;
            int diam = width < height ? width : height;
            g.translate(cx, cy);
            g.setColor(Color.black);
            g.fillOval(-diam / 2, -diam / 2, diam, diam);
            g.setColor(Color.darkGray);
            g.drawLine(-diam / 2, 0, diam / 2, 0);
            g.drawLine(0, -diam / 2, 0, diam / 2);
            g.rotate(-this.theta);
            g.setColor(Color.white);
            int arrowlength = (int)Math.min((double)diam * 0.9, (double)(diam - 2));
            int arrowthick = (int)Math.min((double)diam * 0.1, 5.0);
            int headheight = headlength = Math.min(diam / 3 - 1, 20);
            Rectangle2D.Double rect = new Rectangle2D.Double(-arrowlength / 2, -arrowthick / 2, arrowlength - headlength + 1, arrowthick);
            g.fill(rect);
            g.setColor(Color.blue);
            Polygon p = new Polygon();
            p.addPoint(arrowlength / 2, 0);
            p.addPoint(arrowlength / 2 - headlength, headheight / 2);
            p.addPoint(arrowlength / 2 - headlength, -headheight / 2);
            g.fill(p);
        }
    }

    public class CalibrateActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            GyroPanel.this.gyro.calibrate(4000);
        }
    }
}

