/*
 * Decompiled with CFR 0.152.
 */
package maslab.orcspy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import maslab.orcspy.GoalSliderListener;

public class GoalSlider
extends JComponent {
    public static final long serialVersionUID = 1001L;
    int barheight = 8;
    int minvalue = 0;
    int maxvalue = 100;
    int goalvalue;
    int actualvalue;
    int goalknobsize = 6;
    int actualknobsize = 10;
    int totalheight = this.actualknobsize + 4;
    int marginx = 6;
    ArrayList<GoalSliderListener> gsls = new ArrayList();
    boolean copyactual = false;
    boolean showactual = true;

    public GoalSlider(int min, int max, boolean showactual) {
        this.minvalue = min;
        this.maxvalue = max;
        this.goalvalue = this.minvalue;
        this.actualvalue = this.minvalue;
        this.showactual = showactual;
        this.addMouseMotionListener(new GoalSliderMouseMotionListener());
        this.addMouseListener(new GoalSliderMouseMotionListener());
        this.copyactual = true;
    }

    public GoalSlider(int min, int max, int goalvalue, int actualvalue) {
        this.minvalue = min;
        this.maxvalue = max;
        this.goalvalue = goalvalue;
        this.actualvalue = actualvalue;
        this.addMouseMotionListener(new GoalSliderMouseMotionListener());
        this.addMouseListener(new GoalSliderMouseMotionListener());
    }

    public void addGoalSliderListener(GoalSliderListener gsl) {
        this.gsls.add(gsl);
    }

    public void setMaximum(int i) {
        this.maxvalue = i;
        this.repaint();
    }

    public void setMinimum(int i) {
        this.minvalue = i;
        this.repaint();
    }

    public synchronized void setActualValue(int i) {
        if (this.copyactual) {
            this.goalvalue = i;
            this.copyactual = false;
        }
        this.actualvalue = i;
        this.repaint();
    }

    public void setGoalValue(int i) {
        this.goalvalue = i;
        this.repaint();
    }

    public int getGoalValue() {
        return this.goalvalue;
    }

    public int getActualValue() {
        return this.actualvalue;
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, this.totalheight);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public synchronized void paint(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int height = this.getHeight();
        int width = this.getWidth() - 2 * this.marginx;
        int cy = height / 2;
        int cx = width / 2;
        g.translate(this.marginx, 0);
        g.setColor(this.getParent().getBackground());
        g.fillRect(0, 0, width, height);
        RoundRectangle2D.Double barr = new RoundRectangle2D.Double(0.0, cy - this.barheight / 2, width, this.barheight, this.barheight, this.barheight);
        g.setColor(Color.white);
        g.fill(barr);
        g.setColor(Color.black);
        g.draw(barr);
        int x = width * (this.goalvalue - this.minvalue) / (this.maxvalue - this.minvalue);
        Ellipse2D.Double goalknob = new Ellipse2D.Double(x - this.goalknobsize / 2, cy - this.goalknobsize / 2, this.goalknobsize, this.goalknobsize);
        g.setColor(Color.green);
        g.fill(goalknob);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        g.draw(goalknob);
        if (this.showactual) {
            x = width * (this.actualvalue - this.minvalue) / (this.maxvalue - this.minvalue);
            g.setColor(Color.black);
            g.setStroke(new BasicStroke(1.0f));
            Ellipse2D.Double actualknob = new Ellipse2D.Double(x - this.actualknobsize / 2, cy - this.actualknobsize / 2, this.actualknobsize, this.actualknobsize);
            g.draw(actualknob);
        }
    }

    void handleClick(int x) {
        this.goalvalue = this.minvalue + (this.maxvalue - this.minvalue) * (x - this.marginx) / (this.getWidth() - 2 * this.marginx);
        if (this.goalvalue < this.minvalue) {
            this.goalvalue = this.minvalue;
        }
        if (this.goalvalue > this.maxvalue) {
            this.goalvalue = this.maxvalue;
        }
        for (GoalSliderListener gsl : this.gsls) {
            gsl.goalValueChanged(this, this.goalvalue);
        }
        this.repaint();
    }

    class GoalSliderMouseMotionListener
    implements MouseMotionListener,
    MouseListener {
        GoalSliderMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            GoalSlider.this.handleClick(e.getX());
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            GoalSlider.this.handleClick(e.getX());
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            GoalSlider.this.handleClick(e.getX());
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

