/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import maslab.orc.Orc;
import maslab.orc.RangeSensor;
import maslab.util.Logger;

public class UltrasoundSRF08RangeSensor
implements RangeSensor {
    Orc orc;
    int addr;
    Logger log = new Logger(this);
    public double rangeVariance = 0.002;
    public double arcAngle = 0.52;

    public UltrasoundSRF08RangeSensor(Orc orc) {
        this(orc, 112);
        this.orc = orc;
    }

    public UltrasoundSRF08RangeSensor(Orc orc, int addr) {
        this.orc = orc;
        this.addr = addr;
    }

    public int readRevision() {
        byte[] req = new byte[]{0};
        byte[] resp = new byte[1];
        boolean res = this.orc.i2cWriteRead(this.addr, req, req.length, resp, resp.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return 0;
        }
        return resp[0] & 0xFF;
    }

    public int readLightSensor() {
        byte[] req = new byte[]{1};
        byte[] resp = new byte[1];
        boolean res = this.orc.i2cWriteRead(this.addr, req, req.length, resp, resp.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return 0;
        }
        return resp[0] & 0xFF;
    }

    public double getRange() {
        byte[] req = new byte[2];
        byte[] resp = new byte[8];
        req[0] = 0;
        req[1] = 81;
        boolean res = this.orc.i2cWrite(this.addr, req, 2);
        try {
            Thread.sleep(65L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        req[0] = 2;
        res = this.orc.i2cWriteRead(this.addr, req, 1, resp, 8);
        for (int i = 0; i < 8; i += 2) {
            double range = (resp[i] & 0xFF) * 256 + (resp[i + 1] & 0xFF);
            System.out.print(String.format("%10.2f  ", range));
        }
        return 0.0;
    }

    public double getRangeUncertainty() {
        return this.rangeVariance;
    }

    public double getArcAngle() {
        return this.arcAngle;
    }

    public static void main(String[] args) {
        Orc orc;
        try {
            orc = new Orc();
        }
        catch (Exception ex) {
            return;
        }
        UltrasoundSRF08RangeSensor us = new UltrasoundSRF08RangeSensor(orc);
        System.out.println("revision: " + us.readRevision());
        while (true) {
            System.out.println(String.format("%8d %4f", us.readLightSensor(), us.getRange()));
        }
    }
}

