/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import maslab.orc.Orc;

public class Servo {
    Orc orc;
    int port;
    public int minpwm;
    public int maxpwm;
    public double minangle;
    public double maxangle;

    public Servo(Orc orc, int port) {
        this.orc = orc;
        this.port = port;
        orc.pinModeWrite(port, Orc.PinMode.SERVO);
    }

    public static Servo makeMpiMX400(Orc orc, int port) {
        Servo s = new Servo(orc, port);
        s.minpwm = 5000;
        s.maxpwm = 18000;
        s.minangle = 0.0;
        s.maxangle = 180.0;
        return s;
    }

    public static Servo makeHitecHS300(Orc orc, int port) {
        Servo s = new Servo(orc, port);
        s.minpwm = 7000;
        s.maxpwm = 20000;
        s.minangle = 0.0;
        s.maxangle = 180.0;
        return s;
    }

    public void seek(double angle) {
        int pwm = (int)((double)this.minpwm + (double)(this.maxpwm - this.minpwm) * (angle - this.minangle) / (this.maxangle - this.minangle));
        this.orc.servoWrite(this.port, pwm);
    }

    public double tell() {
        int pwm = this.orc.servoRead(this.port);
        return this.minangle + (this.maxangle - this.minangle) * (double)(pwm - this.minpwm) / (double)(this.maxpwm - this.minpwm);
    }

    public double current() {
        return this.orc.servoCurrentRead(this.port);
    }

    public static void main(String[] args) {
        Orc orc;
        try {
            orc = new Orc();
        }
        catch (Exception ex) {
            System.out.println("Couldn't connect to orc.");
            return;
        }
        Servo s = new Servo(orc, 0);
        System.out.println("Assuming there's a servo on port 0...");
        BufferedReader ins = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String line = "";
            try {
                System.out.print("Set pwm to: ");
                line = ins.readLine();
                int pwm = Integer.parseInt(line);
                orc.servoWrite(0, pwm);
            }
            catch (Exception ex) {
                System.out.println("Huh?");
            }
            System.out.println("Seeked to: " + orc.servoRead(0));
            System.out.println("Current: " + orc.servoCurrentRead(0));
        }
    }
}

