/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import maslab.util.StringUtil;

class OrcPacket {
    public byte[] buf;
    public static final int MASTER_TIMESTAMP = 4;
    public static final int MASTER_DIGITAL_IN = 6;
    public static final int MASTER_SERVO = 8;
    public static final int MASTER_ANALOG = 16;
    public static final int MASTER_LPF = 36;
    public static final int MASTER_PINMODE = 41;
    public static final int MASTER_US_RANGE = 49;
    public static final int MASTER_US_PINGCOUNT = 53;
    public static final int MASTER_CLOCK = 54;
    public static final int MASTER_DAC = 57;
    public static final int MASTER_GYRO = 58;
    public static final int SLAVE_PINMODE = 4;
    public static final int SLAVE_DIGITAL_IN = 6;
    public static final int SLAVE_QUADPHASE = 7;
    public static final int SLAVE_MOTOR = 13;
    public static final int SLAVE_MOTORDIR = 25;
    public static final int SLAVE_ANALOG_IN = 27;
    public static final int SLAVE_MOTOR_CURRENT = 27;
    public static final int SLAVE_SERVO_CURRENT = 35;
    public static final int SLAVE_LPF = 43;
    public static final int SLAVE_TIMESTAMP = 48;
    public static final int SLAVE_STEPPERSPEED = 50;
    public static final int SLAVE_STEPPERPOS = 54;
    public static final int LCD_JOYX = 4;
    public static final int LCD_JOYY = 5;
    public static final int LCD_BUTTONS = 6;
    public static final int LCD_MOVE = 7;
    public static final int LCD_BATTERY_VOLTAGE = 9;

    public OrcPacket() {
    }

    public OrcPacket(byte[] b, int blen, Object ... args) {
        int i;
        this.buf = new byte[args.length + blen + 3];
        this.buf[0] = -19;
        this.buf[1] = (byte)this.buf.length;
        for (i = 0; i < args.length; ++i) {
            Object o = args[i];
            if (o instanceof Byte) {
                this.buf[i + 2] = (Byte)args[i];
                continue;
            }
            if (o instanceof Character) {
                this.buf[i + 2] = (byte)((Character)args[i]).charValue();
                continue;
            }
            if (o instanceof Integer) {
                this.buf[i + 2] = ((Integer)args[i]).byteValue();
                continue;
            }
            assert (false);
        }
        for (i = 0; i < blen; ++i) {
            this.buf[args.length + 2 + i] = b[i];
        }
        this.buf[this.buf.length - 1] = OrcPacket.computeChecksum(this.buf);
    }

    public OrcPacket(Object ... args) {
        this.buf = new byte[args.length + 3];
        this.buf[0] = -19;
        this.buf[1] = (byte)(args.length + 3);
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i];
            if (o instanceof Byte) {
                this.buf[i + 2] = (Byte)args[i];
                continue;
            }
            if (o instanceof Character) {
                this.buf[i + 2] = (byte)((Character)args[i]).charValue();
                continue;
            }
            if (o instanceof Integer) {
                this.buf[i + 2] = ((Integer)args[i]).byteValue();
                continue;
            }
            assert (false);
        }
        this.buf[this.buf.length - 1] = OrcPacket.computeChecksum(this.buf);
    }

    public static OrcPacket fromInputStream(InputStream ins) throws IOException {
        int c;
        OrcPacket p = new OrcPacket();
        int len = 0;
        do {
            if ((c = ins.read()) >= 0) continue;
            return null;
        } while (c != 237);
        len = ins.read() & 0xFF;
        if (len == 0) {
            return null;
        }
        p.buf = new byte[len];
        p.buf[0] = -19;
        p.buf[1] = (byte)(len & 0xFF);
        ins.read(p.buf, 2, len - 2);
        byte chk = OrcPacket.computeChecksum(p.buf);
        if (chk != p.buf[len - 1]) {
            return null;
        }
        return p;
    }

    public void write(OutputStream outs) throws IOException {
        outs.write(this.buf);
    }

    protected static byte computeChecksum(byte[] buf) {
        int chk = 0;
        for (int i = 0; i < buf.length - 1; ++i) {
            chk = (chk << 1) + (buf[i] & 0xFF) + ((chk & 0x80) > 0 ? 1 : 0);
        }
        return (byte)(chk & 0xFF);
    }

    public boolean isSuccess() {
        return this.buf != null && this.buf.length > 4 && this.buf[3] == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.buf == null) {
            sb.append("null");
            return sb.toString();
        }
        sb.append("Payload:  ");
        for (int i = 3; i < this.buf.length - 1; ++i) {
            sb.append("" + StringUtil.formatHex(this.buf[i] & 0xFF, 2) + " ");
            if ((i - 2) % 16 != 0 || i <= 2) continue;
            sb.append("\n          ");
        }
        return sb.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }
}

