/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import maslab.orc.Orc;
import maslab.orc.OrcCommandConnection;
import maslab.orc.OrcPacket;

class OrcCommandService {
    protected BlockingQueue<OrcCommandConnection> commandConnections = new LinkedBlockingQueue<OrcCommandConnection>();
    protected int maxHandlers = 0;
    protected int numHandlers = 0;
    Orc orc;

    public OrcCommandService(Orc orc, int maxHandlers) {
        this.orc = orc;
        this.maxHandlers = maxHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OrcPacket doTransaction(OrcPacket request) {
        OrcCommandService orcCommandService = this;
        synchronized (orcCommandService) {
            while (this.numHandlers < this.maxHandlers) {
                try {
                    this.commandConnections.add(new OrcCommandConnection(this.orc, this.orc.host, this.orc.cmdport));
                    ++this.numHandlers;
                }
                catch (IOException ex) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex2) {}
                }
            }
        }
        try {
            OrcCommandConnection handler = this.commandConnections.take();
            OrcPacket response = handler.doTransaction(request);
            if (response != null) {
                this.commandConnections.add(handler);
            }
            return response;
        }
        catch (InterruptedException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }
}

