/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import maslab.orc.Orc;
import maslab.orc.OrcPacket;
import maslab.util.Logger;

class OrcAsyncConnection {
    protected Socket sock;
    protected InputStream ins;
    protected OutputStream outs;
    protected Logger log = new Logger(this);
    ReaderThread reader;
    String host;
    int port;
    Orc orc;

    public OrcAsyncConnection(Orc orc, String host, int port) {
        this.orc = orc;
        this.host = host;
        this.port = port;
        this.reader = new ReaderThread();
        this.reader.start();
    }

    void reconnect() {
        boolean success = false;
        while (!success) {
            try {
                this.log.debug("Connecting");
                this.sock = new Socket(this.host, this.port);
                this.sock.setTcpNoDelay(true);
                this.ins = new BufferedInputStream(this.sock.getInputStream());
                this.outs = this.sock.getOutputStream();
                success = true;
                this.log.debug("Connected");
            }
            catch (IOException ex) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.log.output("Connected");
    }

    class ReaderThread
    extends Thread {
        public ReaderThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean gotMaster = false;
            boolean gotSlave = false;
            boolean gotPad = false;
            while (true) {
                Orc.OrcPacketHolder h;
                OrcPacket p;
                if (OrcAsyncConnection.this.ins == null) {
                    OrcAsyncConnection.this.reconnect();
                }
                try {
                    p = OrcPacket.fromInputStream(OrcAsyncConnection.this.ins);
                }
                catch (IOException ex) {
                    OrcAsyncConnection.this.reconnect();
                    continue;
                }
                if (p == null) {
                    OrcAsyncConnection.this.reconnect();
                    continue;
                }
                int flags = p.buf[2] & 0xC0;
                if (p.buf[3] != 42) {
                    OrcAsyncConnection.this.log.output("got funny async packet");
                    continue;
                }
                if (flags == 0) {
                    h = OrcAsyncConnection.this.orc.masterHolder;
                    gotMaster = true;
                } else if (flags == 64) {
                    h = OrcAsyncConnection.this.orc.slaveHolder;
                    gotSlave = true;
                } else if (flags == 128) {
                    h = OrcAsyncConnection.this.orc.padHolder;
                    gotPad = true;
                } else {
                    if (flags == 192) {
                        System.out.println("flags=0xc0, type=" + p);
                        continue;
                    }
                    OrcAsyncConnection.this.log.output("Unknown flags: " + flags);
                    continue;
                }
                if (gotMaster && gotSlave || gotPad) {
                    OrcAsyncConnection.this.orc.notifyUpdateListeners();
                    gotMaster = false;
                    gotSlave = false;
                    gotPad = false;
                }
                Orc.OrcPacketHolder orcPacketHolder = h;
                synchronized (orcPacketHolder) {
                    h.time = System.currentTimeMillis();
                    h.packet = p;
                    h.notifyAll();
                }
            }
        }
    }
}

